/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.count.CountValue;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="count", datasetEntityType=DatasetEntity.class)
public class CountDataRepository
extends AbstractDataRepository<DatasetEntity, CountDataEntity, CountValue, Integer> {
    @Override
    protected CountValue createEmptyValue() {
        return new CountValue();
    }

    @Override
    protected Data<CountValue> assembleData(Long dataset, DbQuery query, Session session) {
        Data result = new Data();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(dataset, query);
        for (CountDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.assembleDataValue(observation, observation.getDataset(), query));
        }
        return result;
    }

    @Override
    public CountValue assembleDataValue(CountDataEntity observation, DatasetEntity series, DbQuery query) {
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        Integer observationValue = !service.isNoDataValue((DataEntity)observation) ? (Integer)observation.getValue() : null;
        CountValue value = (CountValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }
}

