/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.HibernateSessionStore;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.CategoryDao;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.db.dao.MeasuringProgramDao;
import org.n52.series.db.dao.OfferingDao;
import org.n52.series.db.dao.PhenomenonDao;
import org.n52.series.db.dao.PlatformDao;
import org.n52.series.db.dao.ProcedureDao;
import org.n52.series.db.dao.SamplingDao;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityCounter {
    private final HibernateSessionStore sessionStore;
    private final DataRepositoryTypeFactory dataRepositoryFactory;
    private final DbQueryFactory dbQueryFactory;

    @Autowired
    public EntityCounter(HibernateSessionStore sesionStore, DataRepositoryTypeFactory dataRepositoryFactory, DbQueryFactory dbQueryFactory) {
        this.sessionStore = sesionStore;
        this.dataRepositoryFactory = dataRepositoryFactory;
        this.dbQueryFactory = dbQueryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countFeatures(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new FeatureDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countOfferings(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new OfferingDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countProcedures(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new ProcedureDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countPhenomena(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new PhenomenonDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countCategories(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new CategoryDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countPlatforms(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new PlatformDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countDatasets(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            IoParameters parameters = query.getParameters();
            if (parameters.getValueTypes().isEmpty()) {
                parameters = parameters.extendWith("valueTypes", this.dataRepositoryFactory.getKnownTypes().toArray(new String[0]));
                Long l = this.getCount(new DatasetDao<DatasetEntity>(session, DatasetEntity.class), this.dbQueryFactory.createFrom(parameters));
                return l;
            }
            Long l = this.getCount(new DatasetDao<DatasetEntity>(session, DatasetEntity.class), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countSamplings(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new SamplingDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countMeasuringPrograms(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Long l = this.getCount(new MeasuringProgramDao(session), query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countStations() throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            DbQuery query = this.createBackwardsCompatibleQuery();
            Long l = this.countFeatures(query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Long countTimeseries() throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            DbQuery query = this.createBackwardsCompatibleQuery();
            Long l = this.countDatasets(query);
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    public Long countTimeseries(DbQuery query) throws DataAccessException {
        return this.countDataset(query, "timeseries");
    }

    public Long countIndividualObservations(DbQuery query) throws DataAccessException {
        return this.countDataset(query, "individualObservation");
    }

    public Long countTrajectories(DbQuery query) throws DataAccessException {
        return this.countDataset(query, "trajectory");
    }

    public Long countProfiles(DbQuery query) throws DataAccessException {
        return this.countDataset(query, "profile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long countDataset(DbQuery query, String datasetType) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            IoParameters parameters = query.getParameters();
            parameters = parameters.extendWith("datasetTypes", new String[]{datasetType});
            Long l = this.getCount(new DatasetDao<DatasetEntity>(session, DatasetEntity.class), this.dbQueryFactory.createFrom(parameters));
            return l;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    public Long getCount(AbstractDao<?> dao, DbQuery query) throws DataAccessException {
        return dao.getCount(query);
    }

    private DbQuery createBackwardsCompatibleQuery() {
        IoParameters parameters = IoParameters.createDefaults();
        return this.dbQueryFactory.createFrom(parameters);
    }
}

