/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.profile.ProfileDataItem;
import org.n52.io.response.dataset.profile.ProfileValue;
import org.n52.io.response.dataset.profile.VerticalExtentOutput;
import org.n52.io.response.dataset.profile.VerticalExtentValueOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.VerticalMetadataEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public abstract class ProfileDataRepository<P extends DatasetEntity, V, T>
extends AbstractDataRepository<P, ProfileDataEntity, ProfileValue<V>, Set<DataEntity<?>>> {
    private static final String PARAMETER_NAME = "name";

    @Override
    protected ProfileDataEntity unproxy(DataEntity<?> dataEntity, Session session) {
        if (dataEntity instanceof HibernateProxy && ((HibernateProxy)dataEntity).getHibernateLazyInitializer().getSession() == null) {
            return this.unproxy((DataEntity<?>)((DataEntity)session.load(dataEntity.getClass(), (Serializable)dataEntity.getId())), session);
        }
        return (ProfileDataEntity)Hibernate.unproxy(dataEntity);
    }

    @Override
    protected ProfileValue<V> createEmptyValue() {
        return new ProfileValue();
    }

    protected boolean isVertical(Map<String, Object> parameterObject, String verticalName) {
        if (parameterObject.containsKey(PARAMETER_NAME)) {
            String value = (String)parameterObject.get(PARAMETER_NAME);
            return value.equalsIgnoreCase(verticalName);
        }
        return false;
    }

    @Override
    protected Data<ProfileValue<V>> assembleData(Long dataset, DbQuery query, Session session) throws DataAccessException {
        query.setComplexParent(true);
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(dataset, query);
        for (ProfileDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue(this.assembleDataValue(observation, (P)observation.getDataset(), query));
        }
        return result;
    }

    @Override
    public ProfileValue<V> assembleDataValue(ProfileDataEntity observation, P dataset, DbQuery query) {
        ProfileValue<V> profile = this.createValue(observation, (DatasetEntity)dataset, query);
        return this.addMetadatasIfNeeded(observation, profile, dataset, query);
    }

    protected ProfileValue<V> createProfileValue(ProfileDataEntity observation, DbQuery query) {
        ProfileValue profile = (ProfileValue)this.prepareValue(observation, query);
        profile.setVerticalExtent(this.createVerticalExtent(observation));
        return profile;
    }

    private VerticalExtentOutput createVerticalExtent(ProfileDataEntity observation) {
        VerticalExtentOutput verticalExtent;
        block3: {
            verticalExtent = new VerticalExtentOutput();
            if (!observation.getDataset().hasVerticalMetadata()) break block3;
            VerticalMetadataEntity verticalMetadata = observation.getDataset().getVerticalMetadata();
            verticalExtent.setUom(verticalMetadata.hasVerticalUnit() ? verticalMetadata.getVerticalUnit().getSymbol() : null);
            if (verticalMetadata.isSetOrientation()) {
                verticalExtent.setOrientation(verticalMetadata.getOrientation());
            }
            if (verticalMetadata.isSetVerticalOriginName()) {
                verticalExtent.setVerticalOrigin(verticalMetadata.getVerticalOriginName());
            }
            verticalExtent.setFrom(new VerticalExtentValueOutput(verticalMetadata.getVerticalFromName(), this.format(observation.getVerticalFrom(), observation.getDataset())));
            verticalExtent.setTo(new VerticalExtentValueOutput(verticalMetadata.getVerticalToName(), this.format(observation.getVerticalTo(), observation.getDataset())));
            Iterator iterator = observation.getValue().iterator();
            if (iterator.hasNext()) {
                DataEntity value = (DataEntity)iterator.next();
                verticalExtent.setInterval(value.hasVerticalInterval());
            }
        }
        return verticalExtent;
    }

    protected abstract ProfileValue<V> createValue(ProfileDataEntity var1, DatasetEntity var2, DbQuery var3);

    protected <E extends DataEntity<V>> ProfileDataItem<V> assembleDataItem(E dataEntity, ProfileValue<T> profile, ProfileDataEntity observation, DbQuery query) {
        ProfileDataItem dataItem = new ProfileDataItem();
        dataItem.setValue(dataEntity.getValue());
        BigDecimal verticalTo = this.format(dataEntity.getVerticalTo(), dataEntity.getDataset());
        BigDecimal verticalFrom = this.format(dataEntity.getVerticalFrom(), dataEntity.getDataset());
        dataItem.setVertical(verticalTo);
        if (dataEntity.hasVerticalInterval()) {
            dataItem.setVerticalFrom(verticalFrom);
        }
        return dataItem;
    }

    protected <E extends DataEntity<T>> ProfileDataItem<T> assembleDataItem(E dataEntity, ProfileValue<T> profile, Set<Map<String, Object>> parameters, DatasetEntity dataset, DbQuery query) {
        ProfileDataItem dataItem = new ProfileDataItem();
        dataItem.setValue(dataEntity.getValue());
        return dataItem;
    }
}

