/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.handler.DatasetFactoryException;
import org.n52.io.handler.DefaultIoFactory;
import org.n52.io.handler.IoHandlerFactory;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ServiceOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.EntityCounter;
import org.n52.series.db.da.ParameterRepository;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.db.dao.ServiceDao;
import org.n52.series.spi.search.SearchResult;
import org.n52.series.spi.search.ServiceSearchResult;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceRepository
extends ParameterRepository<ServiceEntity, ServiceOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRepository.class);
    private static final String SERVICE_TYPE = "Restful series access layer.";
    @Autowired
    private EntityCounter counter;
    @Autowired
    private DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactoryCreator;

    @Override
    protected ServiceOutput prepareEmptyParameterOutput() {
        return new ServiceOutput();
    }

    @Override
    protected SearchResult createEmptySearchResult(String id, String label, String baseUrl) {
        return new ServiceSearchResult().setId(id).setLabel(label).setBaseUrl(baseUrl);
    }

    protected ServiceDao createDao(Session session) {
        return new ServiceDao(session);
    }

    @Override
    protected SearchableDao<ServiceEntity> createSearchableDao(Session session) {
        return new ServiceDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            Long rawId = this.parseId(id);
            ServiceDao dao = this.createDao(session);
            boolean bl = this.isConfiguredServiceInstance(rawId) || dao.hasInstance(rawId, parameters);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    private boolean isConfiguredServiceInstance(Long id) {
        return this.serviceEntity != null && this.serviceEntity.getId().equals(id);
    }

    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    protected List<ServiceEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        return this.serviceEntity != null ? Collections.singletonList(this.serviceEntity) : this.createDao(session).getAllInstances(parameters);
    }

    @Override
    protected ServiceEntity getEntity(Long id, AbstractDao<ServiceEntity> dao, DbQuery query) throws DataAccessException {
        ServiceEntity result;
        ServiceEntity serviceEntity = result = !this.isConfiguredServiceInstance(id) ? dao.getInstance(id, query) : this.serviceEntity;
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return result;
    }

    @Override
    protected ServiceOutput createExpanded(ServiceEntity entity, DbQuery query, Session session) {
        ServiceOutput result = this.getCondensedService(entity, query);
        IoParameters parameters = query.getParameters();
        ServiceOutput.ParameterCount quantities = this.countParameters(result, query);
        boolean supportsFirstLatest = entity.isSupportsFirstLast();
        String serviceUrl = entity.getUrl();
        String type = this.getServiceType(entity);
        result.setValue("serviceUrl", (Object)serviceUrl, parameters, arg_0 -> ((ServiceOutput)result).setServiceUrl(arg_0));
        result.setValue("type", (Object)type, parameters, arg_0 -> ((ServiceOutput)result).setType(arg_0));
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put("quantities", quantities);
        features.put("supportsFirstLatest", supportsFirstLatest);
        features.put("supportedMimeTypes", this.getSupportedDatasets(result));
        String version = entity.getVersion() != null ? entity.getVersion() : "2.0";
        String hrefBase = query.getHrefBase();
        result.setValue("version", (Object)version, parameters, arg_0 -> ((ServiceOutput)result).setVersion(arg_0));
        result.setValue("features", features, parameters, arg_0 -> ((ServiceOutput)result).setFeatures(arg_0));
        result.setValue("href", (Object)hrefBase, parameters, arg_0 -> ((ServiceOutput)result).setHrefBase(arg_0));
        return result;
    }

    private String getServiceType(ServiceEntity entity) {
        return entity.getType() != null ? entity.getType() : SERVICE_TYPE;
    }

    private Map<String, Set<String>> getSupportedDatasets(ServiceOutput service) {
        HashMap<String, Set<String>> mimeTypesByDatasetTypes = new HashMap<String, Set<String>>();
        for (String valueType : this.ioFactoryCreator.getKnownTypes()) {
            try {
                IoHandlerFactory factory = (IoHandlerFactory)this.ioFactoryCreator.create(valueType);
                mimeTypesByDatasetTypes.put(valueType, factory.getSupportedMimeTypes());
            }
            catch (DatasetFactoryException e) {
                LOGGER.error("IO Factory for type '{}' couldn't be created.", (Object)valueType);
            }
        }
        return mimeTypesByDatasetTypes;
    }

    private ServiceOutput.ParameterCount countParameters(ServiceOutput service, DbQuery query) {
        try {
            IoParameters parameters = query.getParameters();
            ServiceOutput.ParameterCount quantities = new ServiceOutput.ParameterCount();
            DbQuery serviceQuery = this.getDbQuery(parameters.extendWith("services", new String[]{service.getId()}).removeAllOf("offset").removeAllOf("limit"));
            quantities.setOfferingsSize(this.counter.countOfferings(serviceQuery));
            quantities.setProceduresSize(this.counter.countProcedures(serviceQuery));
            quantities.setCategoriesSize(this.counter.countCategories(serviceQuery));
            quantities.setPhenomenaSize(this.counter.countPhenomena(serviceQuery));
            quantities.setFeaturesSize(this.counter.countFeatures(serviceQuery));
            quantities.setPlatformsSize(this.counter.countPlatforms(serviceQuery));
            quantities.setDatasets(this.createDatasetCount(this.counter, serviceQuery));
            quantities.setSamplingsSize(this.counter.countSamplings(serviceQuery));
            quantities.setMeasuringProgramsSize(this.counter.countMeasuringPrograms(serviceQuery));
            return quantities;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not count parameter entities.", (Throwable)e);
        }
    }

    private ServiceOutput.DatasetCount createDatasetCount(EntityCounter counter, DbQuery query) {
        ServiceOutput.DatasetCount datasetCount = new ServiceOutput.DatasetCount();
        datasetCount.setTotalAmount(counter.countDatasets(query));
        datasetCount.setAmountTimeseries(counter.countTimeseries(query));
        datasetCount.setAmountIndividualObservations(counter.countIndividualObservations(query));
        datasetCount.setAmountProfiles(counter.countProfiles(query));
        datasetCount.setAmountTrajectories(counter.countTrajectories(query));
        return datasetCount;
    }
}

