/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.joda.time.DateTime;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DataDao<T extends DataEntity>
extends AbstractDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataDao.class);
    private static final Order DEFAULT_ORDER = Order.asc((String)"samplingTimeEnd");
    private final Class<T> entityType;

    public DataDao(Session session) {
        this(session, DataEntity.class);
    }

    public DataDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    @Override
    public T getInstance(Long key, DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)parameters);
        return (T)((DataEntity)this.entityType.cast(this.session.get(this.entityType, (Serializable)key)));
    }

    @Override
    public List<T> getAllInstances(DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)parameters);
        Criteria criteria = this.getDefaultCriteria(parameters);
        parameters.addTimespanTo(criteria);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(DataDao.toSQLString(criteria));
        }
        return criteria.list();
    }

    public List<T> getAllInstancesFor(Long dataset, DbQuery query) throws DataAccessException {
        LOGGER.debug("get all instances for series '{}': {}", (Object)dataset, (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        criteria.createCriteria("dataset").add((Criterion)Restrictions.eq((String)"id", (Object)dataset));
        query.addTimespanTo(criteria);
        return criteria.list();
    }

    public T getClosestOuterPreviousValue(DatasetEntity dataset, DateTime lowerBound, DbQuery query) {
        String column = "samplingTimeStart";
        Order order = Order.desc((String)"samplingTimeStart");
        Criteria criteria = this.createDataCriteria("samplingTimeStart", dataset, query, order);
        return (T)((DataEntity)criteria.add((Criterion)Restrictions.lt((String)"samplingTimeStart", (Object)lowerBound.toDate())).setMaxResults(1).uniqueResult());
    }

    public T getClosestOuterNextValue(DatasetEntity dataset, DateTime upperBound, DbQuery query) {
        String column = "samplingTimeEnd";
        Order order = Order.asc((String)"samplingTimeEnd");
        Criteria criteria = this.createDataCriteria("samplingTimeEnd", dataset, query, order);
        return (T)((DataEntity)criteria.add((Criterion)Restrictions.gt((String)"samplingTimeEnd", (Object)upperBound.toDate())).setMaxResults(1).uniqueResult());
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    @Override
    public Criteria getDefaultCriteria(DbQuery query) {
        return this.getDefaultCriteria(query, DEFAULT_ORDER);
    }

    private Criteria getDefaultCriteria(DbQuery query, Order order) {
        Criteria criteria = this.session.createCriteria(this.entityType).add((Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)).addOrder(order);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        query.addSpatialFilter(criteria);
        query.addResultTimeFilter(criteria);
        query.addOdataFilterForData(criteria);
        criteria.add(Restrictions.isNull((String)"parent"));
        return criteria;
    }

    @Deprecated
    public T getDataValueViaTimeend(DatasetEntity series, DbQuery query) {
        Date timeend = series.getLastValueAt();
        Criteria criteria = this.createDataAtCriteria(timeend, "samplingTimeEnd", series, query);
        return (T)((DataEntity)criteria.uniqueResult());
    }

    @Deprecated
    public T getDataValueViaTimestart(DatasetEntity series, DbQuery query) {
        Date timestart = series.getFirstValueAt();
        Criteria criteria = this.createDataAtCriteria(timestart, "samplingTimeStart", series, query);
        return (T)((DataEntity)criteria.uniqueResult());
    }

    @Deprecated
    public GeometryEntity getValueGeometryViaTimeend(DatasetEntity series, DbQuery query) {
        Date lastValueAt = series.getLastValueAt();
        Criteria criteria = this.createDataAtCriteria(lastValueAt, "samplingTimeEnd", series, query);
        criteria.setProjection((Projection)Projections.property((String)"geometryEntity"));
        return (GeometryEntity)criteria.uniqueResult();
    }

    private Criteria createDataAtCriteria(Date timestamp, String column, DatasetEntity dataset, DbQuery query) {
        LOGGER.debug("get data @{} for '{}'", (Object)new DateTime(timestamp.getTime()), (Object)dataset.getId());
        return this.createDataCriteria(column, dataset, query).add((Criterion)Restrictions.eq((String)column, (Object)timestamp));
    }

    private Criteria createDataCriteria(String column, DatasetEntity dataset, DbQuery query) {
        return this.createDataCriteria(column, dataset, query, DEFAULT_ORDER);
    }

    private Criteria createDataCriteria(String column, DatasetEntity dataset, DbQuery query, Order order) {
        Criteria criteria = this.getDefaultCriteria(query, order);
        criteria.add((Criterion)Restrictions.eq((String)"dataset", (Object)dataset));
        IoParameters parameters = query.getParameters();
        if (parameters.isAllResultTimes()) {
            return criteria;
        }
        if (!parameters.getResultTimes().isEmpty()) {
            return query.addResultTimeFilter(criteria);
        }
        String rtAlias = "rtAlias";
        String rtColumn = QueryUtils.createAssociation(rtAlias, column);
        String rtDatasetId = QueryUtils.createAssociation(rtAlias, "dataset");
        String rtResultTime = QueryUtils.createAssociation(rtAlias, "resultTime");
        DetachedCriteria maxResultTimeQuery = DetachedCriteria.forClass(this.getEntityClass(), (String)rtAlias);
        maxResultTimeQuery.add((Criterion)Restrictions.eq((String)"dataset", (Object)dataset)).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)rtColumn)).add((Projection)Projections.groupProperty((String)rtDatasetId)).add((Projection)Projections.max((String)rtResultTime)));
        criteria.add(Subqueries.propertiesIn((String[])new String[]{column, "dataset", "resultTime"}, (DetachedCriteria)maxResultTimeQuery));
        return criteria;
    }

    public T getLastObservationForSampling(DatasetEntity dataset, Date date, DbQuery query) {
        String column = "samplingTimeEnd";
        Order order = Order.desc((String)"samplingTimeEnd");
        Criteria criteria = this.createDataCriteria("samplingTimeEnd", dataset, query, order);
        return (T)((DataEntity)criteria.add((Criterion)Restrictions.lt((String)"samplingTimeEnd", (Object)DateUtils.addMilliseconds((Date)date, (int)1))).setMaxResults(1).uniqueResult());
    }
}

