/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.ResultTransformer;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DatasetTypesMetadata;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.dataset.DatasetType;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.beans.dataset.ValueType;
import org.n52.series.db.beans.i18n.I18nFeatureEntity;
import org.n52.series.db.beans.i18n.I18nOfferingEntity;
import org.n52.series.db.beans.i18n.I18nPhenomenonEntity;
import org.n52.series.db.beans.i18n.I18nProcedureEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;
import org.n52.series.db.dao.SearchableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DatasetDao<T extends DatasetEntity>
extends AbstractDao<T>
implements SearchableDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetDao.class);
    private static final String FEATURE_PATH_ALIAS = "dsFeature";
    private static final String PROCEDURE_PATH_ALIAS = "dsProcedure";
    private final Class<T> entityType;
    private final DatasetTypesMetadataTransformer transformer = new DatasetTypesMetadataTransformer();

    public DatasetDao(Session session) {
        this(session, DatasetEntity.class);
    }

    public DatasetDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    @Override
    public List<T> find(DbQuery query) {
        LOGGER.debug("find entities: {}", (Object)query);
        String searchTerm = "%" + query.getSearchTerm() + "%";
        Criteria criteria = this.getDefaultCriteria(query);
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)"name", (Object)searchTerm), Restrictions.ilike((String)"name", (Object)searchTerm), Restrictions.ilike((String)"name", (Object)searchTerm), Restrictions.ilike((String)"name", (Object)searchTerm)}));
        this.i18n(I18nOfferingEntity.class, criteria, query);
        this.i18n(I18nPhenomenonEntity.class, criteria, query);
        this.i18n(I18nProcedureEntity.class, criteria, query);
        this.i18n(I18nFeatureEntity.class, criteria, query);
        return criteria.list();
    }

    @Override
    public T getInstance(Long key, DbQuery query) {
        Criteria criteria = this.getDefaultCriteria(this.getDefaultAlias(), false, query);
        return (T)((DatasetEntity)criteria.add((Criterion)Restrictions.eq((String)"id", (Object)key)).uniqueResult());
    }

    @Override
    protected T getInstance(String key, DbQuery query, Class<T> clazz) {
        return (T)((DatasetEntity)super.getInstance(key, query, clazz, this.getDefaultCriteria(null, false, query, clazz)));
    }

    @Override
    public List<T> getAllInstances(DbQuery query) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = query.addFilters(this.getDefaultCriteria(query), this.getDatasetProperty());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(DatasetDao.toSQLString(criteria));
        }
        return criteria.list();
    }

    public List<T> getInstancesWith(FeatureEntity feature, DbQuery query) {
        LOGGER.debug("get instance for feature '{}'", (Object)feature);
        Criteria criteria = this.getDefaultCriteria(query);
        String idColumn = QueryUtils.createAssociation(FEATURE_PATH_ALIAS, "id");
        return criteria.add((Criterion)Restrictions.eq((String)idColumn, (Object)feature.getId())).list();
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    @Override
    protected String getDefaultAlias() {
        return "dataset";
    }

    @Override
    protected Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        return this.getDefaultCriteria(alias, true, query, clazz);
    }

    private Criteria getDefaultCriteria(String alias, boolean ignoreReferenceSeries, DbQuery query) {
        return this.getDefaultCriteria(alias, ignoreReferenceSeries, query, this.getEntityClass());
    }

    private Criteria getDefaultCriteria(String alias, boolean ignoreReferenceSeries, DbQuery query, Class<?> clazz) {
        Criteria criteria = super.getDefaultCriteria(alias, query, clazz);
        if (ignoreReferenceSeries) {
            criteria.createCriteria("procedure", PROCEDURE_PATH_ALIAS, JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.eq((String)"reference", (Object)Boolean.FALSE));
        }
        query.addOdataFilterForDataset(criteria);
        return criteria;
    }

    @Override
    protected Criteria addDatasetFilters(DbQuery query, Criteria criteria) {
        Criteria filter = criteria.add((Criterion)this.createPublishedDatasetFilter());
        query.addSpatialFilter(filter.createCriteria("feature", FEATURE_PATH_ALIAS, JoinType.LEFT_OUTER_JOIN));
        return criteria;
    }

    public List<DatasetTypesMetadata> getDatasetTypesMetadata(Collection<String> datasets, DbQuery query) {
        Criteria criteria = this.getDefaultCriteria(this.getDefaultAlias(), false, query);
        if (query.isMatchDomainIds()) {
            criteria.add(Restrictions.in((String)"identifier", datasets));
        } else {
            criteria.add(Restrictions.in((String)"id", (Collection)datasets.stream().map(d -> Long.parseLong(d)).collect(Collectors.toSet())));
        }
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"id")).add((Projection)Projections.property((String)"datasetType")).add((Projection)Projections.property((String)"observationType")).add((Projection)Projections.property((String)"valueType")));
        criteria.setResultTransformer((ResultTransformer)this.transformer);
        return criteria.list();
    }

    private class DatasetTypesMetadataTransformer
    implements ResultTransformer {
        private static final long serialVersionUID = -373512929481519459L;

        private DatasetTypesMetadataTransformer() {
        }

        public DatasetTypesMetadata transformTuple(Object[] tuple, String[] aliases) {
            DatasetTypesMetadata datasetTypesMetadata = new DatasetTypesMetadata();
            if (tuple != null) {
                datasetTypesMetadata.setId(tuple[0].toString());
                datasetTypesMetadata.setDatasetType(DatasetType.valueOf((String)tuple[1].toString()));
                datasetTypesMetadata.setObservationType(ObservationType.valueOf((String)tuple[2].toString()));
                datasetTypesMetadata.setValueType(ValueType.valueOf((String)tuple[3].toString()));
            }
            return datasetTypesMetadata;
        }

        public List transformList(List collection) {
            return collection;
        }
    }
}

