/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.i18n.I18nEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.SearchableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParameterDao<T extends DescribableEntity, I extends I18nEntity<T>>
extends AbstractDao<T>
implements SearchableDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterDao.class);

    public ParameterDao(Session session) {
        super(session);
    }

    protected abstract Class<I> getI18NEntityClass();

    @Override
    public List<T> find(DbQuery query) {
        LOGGER.debug("find instance: {}", (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        criteria = this.i18n(this.getI18NEntityClass(), criteria, query);
        criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query.getSearchTerm() + "%")));
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    public List<T> getAllInstances(DbQuery query) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        criteria = this.i18n(this.getI18NEntityClass(), criteria, query);
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }
}

