/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.n52.series.db.HibernateSessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SeriesHibernateSessionHolder
implements HibernateSessionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeriesHibernateSessionHolder.class);
    @Autowired
    private SessionFactory seriesSessionFactory;

    @Override
    public Session getSession() {
        Session session = this.seriesSessionFactory.openSession();
        if (session != null && session.isOpen()) {
            session.setHibernateFlushMode(FlushMode.COMMIT);
            session.setCacheMode(CacheMode.IGNORE);
            session.clear();
        }
        return session;
    }

    @Override
    public void returnSession(Session session) {
        if (session != null && session.isOpen()) {
            session.clear();
            session.close();
        }
    }

    @Override
    public void shutdown() {
        LOGGER.info("Closing '{}'", (Object)this.getClass().getSimpleName());
        this.seriesSessionFactory.close();
    }
}

