/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.n52.io.request.IoParameters;
import org.n52.io.response.DetectionLimitOutput;
import org.n52.io.response.TimeOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.parameter.ParameterEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;

public abstract class AbstractDataRepository<S extends DatasetEntity, E extends DataEntity<T>, V extends AbstractValue<?>, T>
extends SessionAwareRepository
implements DataRepository<S, E, V, T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data<V> getData(String datasetId, DbQuery dbQuery) {
        Session session = this.getSession();
        try {
            Data<V> data = dbQuery.isExpanded() ? this.assembleExpandedData(Long.parseLong(datasetId), dbQuery, session) : this.assembleData(Long.parseLong(datasetId), dbQuery, session);
            return data;
        }
        finally {
            this.returnSession(session);
        }
    }

    protected Data<V> assembleExpandedData(S dataset, DbQuery dbQuery, Session session) {
        return this.assembleExpandedData(dataset.getId(), dbQuery, session);
    }

    protected Data<V> assembleExpandedData(Long dataset, DbQuery dbQuery, Session session) {
        return this.assembleData(dataset, dbQuery, session);
    }

    protected Data<V> assembleData(S dataset, DbQuery query, Session session) {
        return this.assembleData(dataset.getId(), query, session);
    }

    protected abstract Data<V> assembleData(Long var1, DbQuery var2, Session var3);

    @Override
    public V assembleDataValueWithMetadata(E data, S dataset, DbQuery query) {
        Object value = this.assembleDataValue(data, dataset, query);
        return this.addMetadatasIfNeeded(data, value, dataset, query);
    }

    @Override
    public V getFirstValue(S entity, Session session, DbQuery query) {
        return entity.getFirstObservation() != null ? (V)this.assembleDataValue(this.unproxy(entity.getFirstObservation(), session), entity, query) : null;
    }

    @Override
    public V getLastValue(S entity, Session session, DbQuery query) {
        return entity.getLastObservation() != null ? (V)this.assembleDataValue(this.unproxy(entity.getLastObservation(), session), entity, query) : null;
    }

    @Override
    public GeometryEntity getLastKnownGeometry(DatasetEntity entity, Session session, DbQuery query) {
        DataEntity lastObservation = entity.getLastObservation();
        return lastObservation != null ? lastObservation.getGeometryEntity() : null;
    }

    protected DatasetDao<S> getSeriesDao(Session session) {
        return new DatasetDao(session);
    }

    protected DataDao<E> createDataDao(Session session) {
        return new DataDao(session);
    }

    protected abstract V createEmptyValue();

    protected V prepareValue(E observation, DbQuery query) {
        V emptyValue = this.createEmptyValue();
        if (observation == null) {
            return emptyValue;
        }
        IoParameters parameters = query.getParameters();
        TimeOutput timeend = this.createTimeOutput(observation.getSamplingTimeEnd(), observation.getDataset().getOriginTimezone(), parameters);
        TimeOutput timestart = this.createTimeOutput(observation.getSamplingTimeStart(), observation.getDataset().getOriginTimezone(), parameters);
        if (parameters.isShowTimeIntervals() && timestart != null) {
            emptyValue.setTimestart(timestart);
        }
        emptyValue.setTimestamp(timeend);
        return emptyValue;
    }

    protected boolean hasValidEntriesWithinRequestedTimespan(List<?> observations) {
        return observations.size() > 0;
    }

    protected boolean hasSingleValidReferenceValue(List<?> observations) {
        return observations.size() == 1;
    }

    protected V addMetadatasIfNeeded(E observation, V value, S dataset, DbQuery query) {
        if (value != null) {
            this.addResultTime((DataEntity<?>)observation, (AbstractValue<?>)value);
            if (query.isExpanded()) {
                this.addValidTime((DataEntity<?>)observation, (AbstractValue<?>)value, query.getParameters());
                this.addParameters((DataEntity<?>)observation, (AbstractValue<?>)value, query);
                this.addGeometry((DataEntity<?>)observation, (AbstractValue<?>)value, query);
            } else if (dataset.isMobile()) {
                this.addGeometry((DataEntity<?>)observation, (AbstractValue<?>)value, query);
            }
        }
        return value;
    }

    protected void addGeometry(DataEntity<?> dataEntity, AbstractValue<?> value, DbQuery query) {
        if (dataEntity.isSetGeometryEntity()) {
            GeometryEntity geometry = dataEntity.getGeometryEntity();
            value.setGeometry(geometry.getGeometry());
        }
    }

    protected void addValidTime(DataEntity<?> observation, AbstractValue<?> value, IoParameters parameters) {
        if (observation.isSetValidStartTime() || observation.isSetValidEndTime()) {
            TimeOutput validFrom = observation.isSetValidStartTime() ? this.createTimeOutput(observation.getValidTimeStart(), parameters) : null;
            TimeOutput validUntil = observation.isSetValidEndTime() ? this.createTimeOutput(observation.getValidTimeEnd(), parameters) : null;
            value.setValidTime(validFrom, validUntil);
        }
    }

    protected void addResultTime(DataEntity<?> observation, AbstractValue<?> value) {
        if (observation.getResultTime() != null) {
            value.setResultTime(new DateTime((Object)observation.getResultTime()));
        }
    }

    protected void addParameters(DataEntity<?> observation, AbstractValue<?> value, DbQuery query) {
        if (observation.hasParameters()) {
            for (ParameterEntity parameter : observation.getParameters()) {
                value.addParameter(parameter.toValueMap(query.getLocale()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getClosestValueBeforeStart(S dataset, DbQuery query) {
        Session session = this.getSession();
        try {
            E e = this.getClosestValueBeforeStart((DatasetEntity)dataset, query, session);
            return e;
        }
        finally {
            this.returnSession(session);
        }
    }

    protected E getClosestValueBeforeStart(DatasetEntity dataset, DbQuery query, Session session) {
        DataDao<E> dao = this.createDataDao(session);
        Interval timespan = query.getTimespan();
        DateTime lowerBound = timespan.getStart();
        return dao.getClosestOuterPreviousValue(dataset, lowerBound, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getClosestValueAfterEnd(S dataset, DbQuery query) {
        Session session = this.getSession();
        try {
            E e = this.getClosestValueAfterEnd((DatasetEntity)dataset, query, session);
            return e;
        }
        finally {
            this.returnSession(session);
        }
    }

    protected E getClosestValueAfterEnd(DatasetEntity dataset, DbQuery query, Session session) {
        DataDao<E> dao = this.createDataDao(session);
        Interval timespan = query.getTimespan();
        DateTime upperBound = timespan.getEnd();
        return dao.getClosestOuterNextValue(dataset, upperBound, query);
    }

    protected E unproxy(DataEntity<?> dataEntity, Session session) {
        if (dataEntity instanceof HibernateProxy && ((HibernateProxy)dataEntity).getHibernateLazyInitializer().getSession() == null) {
            return this.unproxy((DataEntity)session.load(DataEntity.class, (Serializable)dataEntity.getId()), session);
        }
        return (E)((DataEntity)Hibernate.unproxy(dataEntity));
    }

    protected BigDecimal format(BigDecimal value, DatasetEntity dataset) {
        return this.format(value, dataset.getNumberOfDecimals());
    }

    protected BigDecimal format(BigDecimal value, Integer scale) {
        if (value == null || scale == null) {
            return value;
        }
        return value.setScale((int)scale, RoundingMode.HALF_UP);
    }

    protected DetectionLimitOutput getDetectionLimit(DataEntity<?> o) {
        if (o.hasDetectionLimit()) {
            DetectionLimitOutput result = new DetectionLimitOutput();
            result.setFlag(o.getDetectionLimit().getFlag());
            result.setDetectionLimit(o.getDetectionLimit().getDetectionLimit());
            return result;
        }
        return null;
    }
}

