/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.profile.ProfileDataItem;
import org.n52.io.response.dataset.profile.ProfileValue;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.da.ProfileDataRepository;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="quantity-profile", datasetEntityType=DatasetEntity.class)
public class QuantityProfileDataRepository
extends ProfileDataRepository<DatasetEntity, BigDecimal, BigDecimal> {
    private final QuantityDataRepository quantityRepository = new QuantityDataRepository();

    @Override
    protected ProfileValue<BigDecimal> createValue(ProfileDataEntity observation, DatasetEntity dataset, DbQuery query) {
        Locale locale = LocaleHelper.decode((String)query.getLocale());
        NumberFormat formatter = NumberFormat.getInstance(locale);
        ProfileValue profile = this.createProfileValue(observation, query);
        ArrayList dataItems = new ArrayList();
        for (DataEntity dataEntity : observation.getValue()) {
            QuantityDataEntity quantity = (QuantityDataEntity)dataEntity;
            QuantityValue valueItem = this.quantityRepository.createValue((BigDecimal)quantity.getValue(), quantity, query);
            this.addParameters((DataEntity<?>)quantity, (AbstractValue<?>)valueItem, query);
            if (dataEntity.hasVerticalFrom() || dataEntity.hasVerticalTo()) {
                ProfileDataItem item = this.assembleDataItem(quantity, profile, observation, query);
                item.setValueFormatter(formatter::format);
                dataItems.add(item);
                continue;
            }
            Set parameters = valueItem.getParameters();
            ProfileDataItem item = this.assembleDataItem(quantity, profile, parameters, dataset, query);
            item.setValueFormatter(formatter::format);
            dataItems.add(item);
        }
        profile.setValue(dataItems);
        return profile;
    }
}

