/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.FeatureOutput;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.sampling.MeasuringProgramOutput;
import org.n52.io.response.sampling.SamplerOutput;
import org.n52.io.response.sampling.SamplingObservationOutput;
import org.n52.io.response.sampling.SamplingOutput;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.sampling.MeasuringProgramEntity;
import org.n52.series.db.beans.sampling.SamplingEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.ParameterRepository;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.SamplingDao;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.spi.search.SamplingSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;

public class SamplingRepository
extends ParameterRepository<SamplingEntity, SamplingOutput>
implements OutputAssembler<SamplingOutput> {
    @Autowired
    private DataRepositoryTypeFactory dataRepositoryFactory;

    @Override
    protected SamplingOutput prepareEmptyParameterOutput() {
        return new SamplingOutput();
    }

    @Override
    protected SearchResult createEmptySearchResult(String id, String label, String baseUrl) {
        return new SamplingSearchResult().setId(id).setLabel(label).setBaseUrl(baseUrl);
    }

    @Override
    protected AbstractDao<SamplingEntity> createDao(Session session) {
        return new SamplingDao(session);
    }

    @Override
    protected SearchableDao<SamplingEntity> createSearchableDao(Session session) {
        return new SamplingDao(session);
    }

    @Override
    protected SamplingOutput createCondensed(SamplingEntity sampling, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        SamplingOutput result = this.createCondensed(this.prepareEmptyParameterOutput(), (DescribableEntity)sampling, query);
        result.setValue("domainId", (Object)sampling.getIdentifier(), parameters, arg_0 -> ((SamplingOutput)result).setDomainId(arg_0));
        result.setValue("comment", (Object)(sampling.isSetDescription() ? sampling.getDescription() : ""), parameters, arg_0 -> ((SamplingOutput)result).setComment(arg_0));
        result.setValue("measuringProgram", (Object)this.getCondensedMeasuringProgram(sampling.getMeasuringProgram(), query), parameters, arg_0 -> ((SamplingOutput)result).setMeasuringProgram(arg_0));
        result.setValue("sampler", (Object)this.getCondensedSampler(sampling.getSampler(), parameters), parameters, arg_0 -> ((SamplingOutput)result).setSampler(arg_0));
        result.setValue("samplingMehtod", (Object)sampling.getSamplingMethod(), parameters, arg_0 -> ((SamplingOutput)result).setSamplingMethod(arg_0));
        result.setValue("environmentalConditions", (Object)(sampling.isSetEnvironmentalConditions() ? sampling.getEnvironmentalConditions() : ""), parameters, arg_0 -> ((SamplingOutput)result).setEnvironmentalConditions(arg_0));
        result.setValue("samplingTimeStart", (Object)this.createTimeOutput(sampling.getSamplingTimeStart(), parameters), parameters, arg_0 -> ((SamplingOutput)result).setSamplingTimeStart(arg_0));
        result.setValue("samplingTimeEnd", (Object)this.createTimeOutput(sampling.getSamplingTimeEnd(), parameters), parameters, arg_0 -> ((SamplingOutput)result).setSamplingTimeEnd(arg_0));
        return result;
    }

    @Override
    protected SamplingOutput createExpanded(SamplingEntity sampling, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        SamplingOutput result = this.createCondensed(sampling, query, session);
        result.setValue("feature", (Object)this.getFeature(sampling, query), parameters, arg_0 -> ((SamplingOutput)result).setFeature(arg_0));
        result.setValue("samplingObservations", this.getSamplingObservations(sampling, query), parameters, arg_0 -> ((SamplingOutput)result).setSamplingObservations(arg_0));
        return result;
    }

    private MeasuringProgramOutput getCondensedMeasuringProgram(MeasuringProgramEntity entity, DbQuery query) {
        return this.createCondensed(new MeasuringProgramOutput(), (DescribableEntity)entity, query);
    }

    private SamplerOutput getCondensedSampler(String sampler, IoParameters parameters) {
        if (sampler != null) {
            SamplerOutput result = new SamplerOutput();
            result.setValue("label", (Object)sampler, parameters, arg_0 -> ((SamplerOutput)result).setLabel(arg_0));
            return result;
        }
        return null;
    }

    private FeatureOutput getFeature(SamplingEntity sampling, DbQuery query) {
        if (sampling.hasDatasets()) {
            return this.getCondensedFeature(((DatasetEntity)sampling.getDatasets().iterator().next()).getFeature(), query);
        }
        if (sampling.hasObservations()) {
            return this.getCondensedFeature(((DataEntity)sampling.getObservations().iterator().next()).getDataset().getFeature(), query);
        }
        return null;
    }

    private List<SamplingObservationOutput> getSamplingObservations(SamplingEntity sampling, DbQuery query) {
        TreeSet<DataEntity> observations = new TreeSet<DataEntity>();
        if (sampling.hasObservations()) {
            for (DataEntity o2 : sampling.getObservations()) {
                if (o2.hasParent()) continue;
                observations.add((DataEntity)Hibernate.unproxy((Object)o2));
            }
        }
        return observations.stream().map(o -> this.getObservation((DataEntity<?>)o, query)).collect(Collectors.toList());
    }

    private SamplingObservationOutput getObservation(DataEntity<?> o, DbQuery query) {
        SamplingObservationOutput result = new SamplingObservationOutput();
        DataRepository<DatasetEntity, ?, ?, ?> factory = this.getDataRepositoryFactory(o.getDataset());
        result.setValue(factory.assembleDataValue(o, o.getDataset(), query));
        String uom = o.getDataset().getUnitI18nName(query.getLocale());
        result.setUom(uom != null && !uom.isEmpty() ? OptionalOutput.of((Object)uom) : null);
        result.setDataset(this.createCondensed(new DatasetOutput(), (DescribableEntity)o.getDataset(), query));
        result.setCategory(this.getCondensedCategory(o.getDataset().getCategory(), query));
        result.setOffering(this.getCondensedOffering(o.getDataset().getOffering(), query));
        result.setPhenomenon(this.getCondensedPhenomenon(o.getDataset().getPhenomenon(), query));
        result.setPlatform(this.getCondensedPlatform(o.getDataset().getPlatform(), query));
        result.setProcedure(this.getCondensedProcedure(o.getDataset().getProcedure(), query));
        return result;
    }

    private DataRepository<DatasetEntity, ?, ?, ?> getDataRepositoryFactory(DatasetEntity dataset) {
        return this.dataRepositoryFactory.create(dataset.getObservationType().name(), dataset.getValueType().name(), DatasetEntity.class);
    }
}

