/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.text.TextValue;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="text", datasetEntityType=DatasetEntity.class)
public class TextDataRepository
extends AbstractDataRepository<DatasetEntity, TextDataEntity, TextValue, String> {
    @Override
    protected TextValue createEmptyValue() {
        return new TextValue();
    }

    @Override
    protected Data<TextValue> assembleData(Long dataset, DbQuery query, Session session) {
        Data result = new Data();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(dataset, query);
        for (TextDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.assembleDataValue(observation, observation.getDataset(), query));
        }
        return result;
    }

    @Override
    public TextValue assembleDataValue(TextDataEntity observation, DatasetEntity series, DbQuery query) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        String observationValue = !service.isNoDataValue((DataEntity)observation) ? (String)observation.getValue() : null;
        TextValue value = this.createValue(observation, series, query, observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }

    private TextValue createValue(TextDataEntity observation, DatasetEntity series, DbQuery query, String observationValue) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        String textValue = !service.isNoDataValue((DataEntity)observation) ? (String)observation.getValue() : null;
        return this.createValue(textValue, observation, query);
    }

    TextValue createValue(String observationValue, TextDataEntity observation, DbQuery query) {
        TextValue value = (TextValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return value;
    }
}

