/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.StationOutput;
import org.n52.io.response.dataset.TimeseriesMetadataOutput;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.dataset.ValueType;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.da.StationRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.SearchResult;
import org.n52.series.spi.search.TimeseriesSearchResult;
import org.n52.web.exception.ResourceNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;

public class TimeseriesRepository
extends SessionAwareRepository
implements OutputAssembler<TimeseriesMetadataOutput> {
    private final StationRepository stationRepository;
    private final QuantityDataRepository repository;

    @Autowired
    public TimeseriesRepository(StationRepository stationRepository, QuantityDataRepository dataRepository) {
        this.stationRepository = stationRepository;
        this.repository = dataRepository;
    }

    private DatasetDao<DatasetEntity> createDao(Session session) {
        return new DatasetDao<DatasetEntity>(session, DatasetEntity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            DatasetDao<DatasetEntity> dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, DatasetEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            DatasetDao<DatasetEntity> seriesDao = this.createDao(session);
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            List<DatasetEntity> found = seriesDao.find(query);
            List<SearchResult> list = this.convertToResults(found, query.getLocale());
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    private List<SearchResult> convertToResults(List<DatasetEntity> found, String locale) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DatasetEntity searchResult : found) {
            String pkid = searchResult.getId().toString();
            String phenomenonLabel = searchResult.getPhenomenon().getLabelFrom(locale);
            String procedureLabel = searchResult.getProcedure().getLabelFrom(locale);
            String stationLabel = searchResult.getFeature().getLabelFrom(locale);
            String offeringLabel = searchResult.getOffering().getLabelFrom(locale);
            String label = this.createTimeseriesLabel(phenomenonLabel, procedureLabel, stationLabel, offeringLabel);
            results.add(new TimeseriesSearchResult().setId(pkid).setLabel(label));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimeseriesMetadataOutput> getAllCondensed(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<TimeseriesMetadataOutput> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<TimeseriesMetadataOutput> getAllCondensed(DbQuery query, Session session) throws DataAccessException {
        ArrayList<TimeseriesMetadataOutput> results = new ArrayList<TimeseriesMetadataOutput>();
        DatasetDao<DatasetEntity> seriesDao = this.createDao(session);
        for (DatasetEntity timeseries : seriesDao.getAllInstances(query)) {
            results.add(this.createCondensed(timeseries, query, session));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimeseriesMetadataOutput> getAllExpanded(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<TimeseriesMetadataOutput> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<TimeseriesMetadataOutput> getAllExpanded(DbQuery query, Session session) throws DataAccessException {
        ArrayList<TimeseriesMetadataOutput> results = new ArrayList<TimeseriesMetadataOutput>();
        DatasetDao<DatasetEntity> seriesDao = this.createDao(session);
        for (DatasetEntity timeseries : seriesDao.getAllInstances(query)) {
            results.add(this.createExpanded(timeseries, query, session));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeseriesMetadataOutput getInstance(String timeseriesId, DbQuery dbQuery) throws DataAccessException {
        Session session = this.getSession();
        try {
            TimeseriesMetadataOutput timeseriesMetadataOutput = this.getInstance(timeseriesId, dbQuery, session);
            return timeseriesMetadataOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public TimeseriesMetadataOutput getInstance(String timeseriesId, DbQuery dbQuery, Session session) throws DataAccessException {
        DatasetDao<DatasetEntity> seriesDao = this.createDao(session);
        DatasetEntity result = seriesDao.getInstance(this.parseId(timeseriesId), dbQuery);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + timeseriesId + "' could not be found.");
        }
        return this.createExpanded(result, dbQuery, session);
    }

    protected TimeseriesMetadataOutput createExpanded(DatasetEntity series, DbQuery query, Session session) throws DataAccessException {
        TimeseriesMetadataOutput result = this.createCondensed(series, query, session);
        List<ReferenceValueOutput<QuantityValue>> refValues = this.createReferenceValueOutputs(series, query);
        DatasetParameters timeseries = this.createTimeseriesOutput(series, query.withoutFieldsFilter());
        QuantityValue firstValue = (QuantityValue)this.repository.getFirstValue(series, session, query);
        QuantityValue lastValue = (QuantityValue)this.repository.getLastValue(series, session, query);
        IoParameters params = query.getParameters();
        result.setValue("referenceValues", refValues, params, arg_0 -> ((TimeseriesMetadataOutput)result).setReferenceValues(arg_0));
        result.setValue("parameters", (Object)timeseries, params, arg_0 -> ((TimeseriesMetadataOutput)result).setDatasetParameters(arg_0));
        result.setValue("firstValue", (Object)firstValue, params, arg_0 -> ((TimeseriesMetadataOutput)result).setFirstValue(arg_0));
        result.setValue("lastValue", (Object)lastValue, params, arg_0 -> ((TimeseriesMetadataOutput)result).setLastValue(arg_0));
        return result;
    }

    private List<ReferenceValueOutput<QuantityValue>> createReferenceValueOutputs(DatasetEntity series, DbQuery query) throws DataAccessException {
        ArrayList<ReferenceValueOutput<QuantityValue>> outputs = new ArrayList<ReferenceValueOutput<QuantityValue>>();
        List referenceValues = series.getReferenceValues();
        for (DatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue() || !referenceSeriesEntity.getValueType().equals((Object)ValueType.quantity)) continue;
            ReferenceValueOutput refenceValueOutput = new ReferenceValueOutput();
            ProcedureEntity procedure = referenceSeriesEntity.getProcedure();
            refenceValueOutput.setLabel(procedure.getNameI18n(query.getLocale()));
            refenceValueOutput.setReferenceValueId(referenceSeriesEntity.getId().toString());
            QuantityDataEntity lastValue = (QuantityDataEntity)referenceSeriesEntity.getLastObservation();
            refenceValueOutput.setLastValue((AbstractValue)this.repository.assembleDataValue(lastValue, referenceSeriesEntity, query));
            outputs.add((ReferenceValueOutput<QuantityValue>)refenceValueOutput);
        }
        return outputs;
    }

    private TimeseriesMetadataOutput createCondensed(DatasetEntity entity, DbQuery query, Session session) throws DataAccessException {
        IoParameters parameters = query.getParameters();
        TimeseriesMetadataOutput result = new TimeseriesMetadataOutput(parameters);
        String locale = query.getLocale();
        PhenomenonEntity phenomenon = entity.getPhenomenon();
        String phenomenonLabel = phenomenon.getLabelFrom(locale);
        ProcedureEntity procedure = entity.getProcedure();
        String procedureLabel = procedure.getLabelFrom(locale);
        AbstractFeatureEntity feature = entity.getFeature();
        String stationLabel = feature.getLabelFrom(locale);
        OfferingEntity offering = entity.getOffering();
        String offeringLabel = offering.getLabelFrom(locale);
        Long pkid = entity.getId();
        String uom = entity.getUnitI18nName(locale);
        String label = this.createTimeseriesLabel(phenomenonLabel, procedureLabel, stationLabel, offeringLabel);
        StationOutput station = this.createCondensedStation(entity, query.withoutFieldsFilter(), session);
        result.setId(pkid.toString());
        result.setValue("label", (Object)label, parameters, arg_0 -> ((TimeseriesMetadataOutput)result).setLabel(arg_0));
        result.setValue("uom", (Object)uom, parameters, arg_0 -> ((TimeseriesMetadataOutput)result).setUom(arg_0));
        result.setValue("station", (Object)station, parameters, arg_0 -> ((TimeseriesMetadataOutput)result).setStation(arg_0));
        return result;
    }

    private String createTimeseriesLabel(String phenomenon, String procedure, String station, String offering) {
        StringBuilder sb = new StringBuilder();
        sb.append(phenomenon).append(" ");
        sb.append(procedure).append(", ");
        sb.append(station).append(", ");
        return sb.append(offering).toString();
    }

    private StationOutput createCondensedStation(DatasetEntity entity, DbQuery query, Session session) throws DataAccessException {
        AbstractFeatureEntity feature = entity.getFeature();
        String featurePkid = Long.toString(feature.getId());
        return this.stationRepository.getCondensedInstance(featurePkid, query, session);
    }
}

