/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.srv;

import java.util.ArrayList;
import java.util.List;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.exception.InternalServerException;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessService<T extends ParameterOutput>
extends ParameterService<T> {
    protected final OutputAssembler<T> repository;
    @Autowired
    protected DbQueryFactory dbQueryFactory;

    public AccessService(OutputAssembler<T> repository) {
        this.repository = repository;
    }

    public OutputCollection<T> getExpandedParameters(IoParameters query) {
        try {
            DbQuery dbQuery = this.dbQueryFactory.createFrom(query);
            List<T> results = this.repository.getAllExpanded(dbQuery);
            return new OutputCollection(results);
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get expanded data.", (Throwable)e);
        }
    }

    public OutputCollection<T> getCondensedParameters(IoParameters query) {
        try {
            DbQuery dbQuery = this.dbQueryFactory.createFrom(query);
            List<T> results = this.repository.getAllCondensed(dbQuery);
            return new OutputCollection(results);
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get condensed data.", (Throwable)e);
        }
    }

    public OutputCollection<T> getParameters(String[] ids, IoParameters query) {
        try {
            DbQuery dbQuery = this.dbQueryFactory.createFrom(query);
            ArrayList<T> results = new ArrayList<T>();
            for (String id : ids) {
                results.add(this.repository.getInstance(id, dbQuery));
            }
            return new OutputCollection(results);
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get multiple instance data.", (Throwable)e);
        }
    }

    public T getParameter(String id, IoParameters query) {
        try {
            DbQuery dbQuery = this.dbQueryFactory.createFrom(query);
            return (T)((ParameterOutput)this.repository.getInstance(id, dbQuery));
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get instance data.", (Throwable)e);
        }
    }

    public boolean exists(String id, IoParameters parameters) {
        try {
            return this.repository.exists(id, this.dbQueryFactory.createFrom(parameters));
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not check if resource '" + id + "' does exist.");
        }
    }
}

