/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.dao.spring;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@EnableWebMvc
@Configuration
@PropertySource(value={"file://${local.configFile}"}, ignoreResourceNotFound=true)
public class DefaultConfig
implements WebMvcConfigurer {
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON}).mediaType("json", MediaType.APPLICATION_JSON).useRegisteredExtensionsOnly(false);
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        View jsonView = this.createJsonView();
        registry.enableContentNegotiation(new View[]{jsonView});
    }

    private View createJsonView() {
        MappingJackson2JsonView jsonView = new MappingJackson2JsonView();
        jsonView.setExtractValueFromSingleKeyModel(true);
        jsonView.setDisableCaching(false);
        jsonView.setObjectMapper(this.getObjectMapper());
        return jsonView;
    }

    private ObjectMapper getObjectMapper() {
        return this.objectMapper == null ? this.createDefaultObjectMapper() : this.objectMapper;
    }

    private ObjectMapper createDefaultObjectMapper() {
        return this.setObjectMappter(new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true));
    }

    private ObjectMapper setObjectMappter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return objectMapper;
    }
}

