/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector;

import java.util.List;
import java.util.stream.Collectors;
import org.n52.janmayen.function.Functions;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.connector.SOS2Connector;
import org.n52.proxy.connector.constellations.QuantityDatasetConstellation;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.response.GetFeatureOfInterestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HydroSOSConnector
extends SOS2Connector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HydroSOSConnector.class);

    @Override
    protected boolean canHandle(DataSourceConfiguration config, GetCapabilitiesResponse capabilities) {
        return false;
    }

    @Override
    public ServiceConstellation getConstellation(DataSourceConfiguration config, GetCapabilitiesResponse capabilities) {
        ServiceConstellation serviceConstellation = new ServiceConstellation();
        config.setVersion("2.0.0");
        config.setConnector(this.getConnectorName());
        this.addService(config, serviceConstellation);
        SosCapabilities sosCaps = (SosCapabilities)capabilities.getCapabilities();
        this.addDatasets(serviceConstellation, sosCaps, config);
        return serviceConstellation;
    }

    @Override
    public List<DataEntity<?>> getObservations(DatasetEntity seriesEntity, DbQuery query) {
        List<DataEntity<?>> data = this.getObservation(seriesEntity, this.createTimeFilter(query)).getObservationCollection().toStream().map(Functions.currySecond(this::createDataEntity, (Object)seriesEntity)).collect(Collectors.toList());
        LOGGER.info("Found {} Entries", (Object)data.size());
        return data;
    }

    @Override
    protected void doForOffering(SosObservationOffering obsOff, ServiceConstellation serviceConstellation, DataSourceConfiguration config) {
        String offeringId = this.addOffering(obsOff, serviceConstellation);
        obsOff.getProcedures().forEach(procedureId -> {
            this.addProcedure((String)procedureId, true, false, serviceConstellation);
            obsOff.getObservableProperties().forEach(phenomenonId -> {
                this.addPhenomenon((String)phenomenonId, serviceConstellation);
                String categoryId = this.addCategory((String)phenomenonId, serviceConstellation);
                GetFeatureOfInterestResponse foiResponse = this.getFeatureOfInterestByProcedure((String)procedureId, config.getUrl());
                AbstractFeature abstractFeature = foiResponse.getAbstractFeature();
                if (abstractFeature instanceof FeatureCollection) {
                    FeatureCollection featureCollection = (FeatureCollection)abstractFeature;
                    featureCollection.getMembers().forEach((key, feature) -> {
                        String featureId = this.addFeature((SamplingFeature)feature, serviceConstellation);
                        serviceConstellation.add(new QuantityDatasetConstellation((String)procedureId, offeringId, categoryId, (String)phenomenonId, featureId));
                    });
                }
            });
        });
    }
}

