/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.util.Map;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.count.CountValue;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.da.ProxyDataRepository;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.CountDatasetEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.da.CountDataRepository;
import org.n52.series.db.dao.DbQuery;

public class ProxyCountDataRepository
extends CountDataRepository
implements ProxyDataRepository<CountDatasetEntity, CountDataEntity, CountValue, Integer> {
    private Map<String, AbstractConnector> connectorMap;

    @Override
    public void setConnectorMap(Map<String, AbstractConnector> connectorMap) {
        this.connectorMap = connectorMap;
    }

    public CountValue getFirstValue(CountDatasetEntity entity, Session session, DbQuery query) {
        DataEntity firstObs = this.getConnector(entity).getFirstObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((CountDataEntity)firstObs, entity, query);
    }

    public CountValue getLastValue(CountDatasetEntity entity, Session session, DbQuery query) {
        DataEntity lastObs = this.getConnector(entity).getLastObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((CountDataEntity)lastObs, entity, query);
    }

    protected Data<CountValue> assembleData(CountDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        this.getConnector(seriesEntity).getObservations((DatasetEntity)seriesEntity, query).stream().map(entry -> this.assembleDataValue((CountDataEntity)entry, seriesEntity, query)).forEach(entry -> result.addNewValue((AbstractValue)entry));
        return result;
    }

    private AbstractConnector getConnector(CountDatasetEntity entity) {
        String connectorName = ((ProxyServiceEntity)entity.getService()).getConnector();
        return this.connectorMap.get(connectorName);
    }
}

