/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.util.Map;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.text.TextValue;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.da.ProxyDataRepository;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.beans.TextDatasetEntity;
import org.n52.series.db.da.TextDataRepository;
import org.n52.series.db.dao.DbQuery;

public class ProxyTextDataRepository
extends TextDataRepository
implements ProxyDataRepository<TextDatasetEntity, TextDataEntity, TextValue, String> {
    private Map<String, AbstractConnector> connectorMap;

    @Override
    public void setConnectorMap(Map<String, AbstractConnector> connectorMap) {
        this.connectorMap = connectorMap;
    }

    public TextValue getFirstValue(TextDatasetEntity entity, Session session, DbQuery query) {
        DataEntity firstObs = this.getConnector(entity).getFirstObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((TextDataEntity)firstObs, entity, query);
    }

    public TextValue getLastValue(TextDatasetEntity entity, Session session, DbQuery query) {
        DataEntity lastObs = this.getConnector(entity).getLastObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((TextDataEntity)lastObs, entity, query);
    }

    protected Data<TextValue> assembleData(TextDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        this.getConnector(seriesEntity).getObservations((DatasetEntity)seriesEntity, query).stream().map(entry -> this.assembleDataValue((TextDataEntity)entry, seriesEntity, query)).forEach(entry -> result.addNewValue((AbstractValue)entry));
        return result;
    }

    private AbstractConnector getConnector(TextDatasetEntity entity) {
        String connectorName = ((ProxyServiceEntity)entity.getService()).getConnector();
        return this.connectorMap.get(connectorName);
    }
}

