/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.n52.proxy.db.dao.ClearDao;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.dao.CategoryDao;

public class ProxyCategoryDao
extends CategoryDao
implements InsertDao<CategoryEntity>,
ClearDao<CategoryEntity> {
    private static final String COLUMN_SERVICE_PKID = "service.pkid";

    public ProxyCategoryDao(Session session) {
        super(session);
    }

    @Override
    public CategoryEntity getOrInsertInstance(CategoryEntity category) {
        CategoryEntity instance = this.getInstance(category);
        if (instance != null) {
            return instance;
        }
        this.session.save((Object)category);
        return category;
    }

    private CategoryEntity getInstance(CategoryEntity category) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)"domainId", (Object)category.getDomainId())).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)category.getService().getPkid()));
        return (CategoryEntity)criteria.uniqueResult();
    }

    @Override
    public void clearUnusedForService(ServiceEntity service) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)service.getPkid())).add(Subqueries.propertyNotIn((String)"pkid", (DetachedCriteria)this.createDetachedDatasetFilter()));
        criteria.list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
    }

    private DetachedCriteria createDetachedDatasetFilter() {
        return DetachedCriteria.forClass(DatasetEntity.class).setProjection(Projections.distinct((Projection)Projections.property((String)this.getDatasetProperty())));
    }
}

