/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.harvest;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.io.task.ScheduledJob;
import org.n52.proxy.config.ConfigurationReader;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.db.da.InsertRepository;
import org.n52.proxy.harvest.DataSourceHarvesterJob;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DataSourceHarvesterScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceHarvesterScheduler.class);
    private ConfigurationReader configurationProvider;
    private List<ScheduledJob> scheduledJobs = new ArrayList<ScheduledJob>();
    private int startupDelayInSeconds = 5;
    private Scheduler scheduler;
    private boolean enabled = true;
    @Autowired
    private InsertRepository insertRepository;

    public void init() {
        if (!this.enabled) {
            LOGGER.info("Job schedular disabled. No jobs will be triggered. This is also true for particularly enabled jobs.");
            return;
        }
        Set<DataSourceConfiguration> configuredServices = this.configurationProvider.getDataSource().stream().filter(t -> t.getJob().isEnabled()).collect(Collectors.toSet());
        this.insertRepository.removeNonMatchingServices(configuredServices);
        this.configurationProvider.getDataSource().stream().peek(config -> LOGGER.info("{} {}", (Object)config.getItemName(), (Object)config.getUrl())).map(config -> {
            DataSourceHarvesterJob job = new DataSourceHarvesterJob();
            job.init((DataSourceConfiguration)config);
            return job;
        }).forEach(this::scheduleJob);
        try {
            this.scheduler.startDelayed(this.startupDelayInSeconds);
            LOGGER.info("Scheduler will start jobs in {}s ...", (Object)this.startupDelayInSeconds);
        }
        catch (SchedulerException e) {
            LOGGER.error("Could not start scheduler.", (Throwable)e);
        }
    }

    private void scheduleJob(ScheduledJob taskToSchedule) {
        try {
            if (taskToSchedule.isEnabled()) {
                JobDetail details = taskToSchedule.createJobDetails();
                Trigger trigger = taskToSchedule.createTrigger(details.getKey());
                this.scheduler.scheduleJob(details, trigger);
                if (taskToSchedule.isTriggerAtStartup()) {
                    LOGGER.debug("Schedule job '{}' to run once at startup.", (Object)details.getKey());
                    Trigger onceAtStartup = TriggerBuilder.newTrigger().withIdentity(details.getKey() + "_onceAtStartup").forJob(details.getKey()).build();
                    this.scheduler.scheduleJob(onceAtStartup);
                }
            }
        }
        catch (SchedulerException e) {
            LOGGER.warn("Could not schdule Job '{}'.", (Object)taskToSchedule.getJobName(), (Object)e);
        }
    }

    public void shutdown() {
        try {
            this.scheduler.shutdown(true);
            LOGGER.info("Shutdown scheduler");
        }
        catch (SchedulerException e) {
            LOGGER.error("Could not scheduler.", (Throwable)e);
        }
    }

    public List<ScheduledJob> getScheduledJobs() {
        return this.scheduledJobs;
    }

    public void setScheduledJobs(List<ScheduledJob> scheduledJobs) {
        this.scheduledJobs = scheduledJobs;
    }

    public int getStartupDelayInSeconds() {
        return this.startupDelayInSeconds;
    }

    public void setStartupDelayInSeconds(int startupDelayInSeconds) {
        this.startupDelayInSeconds = startupDelayInSeconds;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ConfigurationReader getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationReader configurationProvider) {
        this.configurationProvider = configurationProvider;
    }
}

