/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.janmayen.function.Functions;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.connector.SOS2Connector;
import org.n52.proxy.connector.constellations.ProfileDatasetConstellation;
import org.n52.proxy.connector.utils.EntityBuilder;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.beans.parameter.ParameterQuantity;
import org.n52.series.db.dao.DbQuery;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.om.values.SweDataArrayValue;
import org.n52.shetland.ogc.ows.OwsServiceProvider;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sensorML.SensorML;
import org.n52.shetland.ogc.sensorML.System;
import org.n52.shetland.ogc.sensorML.elements.SmlComponent;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.request.DescribeSensorRequest;
import org.n52.shetland.ogc.sos.response.GetFeatureOfInterestResponse;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweAbstractDataRecord;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanotronSosConnector
extends SOS2Connector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OceanotronSosConnector.class);
    private static final String OM_2_MIMETYPE = "text/xml;subtype=\"http://www.opengis.net/om/2.0\"";

    @Override
    public boolean canHandle(DataSourceConfiguration config, GetCapabilitiesResponse capabilities) {
        return capabilities.getCapabilities().getServiceProvider().map(OwsServiceProvider::getProviderName).filter(name -> name.equals("Geomatys")).isPresent();
    }

    @Override
    public List<DataEntity<?>> getObservations(DatasetEntity seriesEntity, DbQuery query) {
        GetObservationResponse observationResponse = this.getObservation(seriesEntity, null, OM_2_MIMETYPE);
        return observationResponse.getObservationCollection().toStream().map(observation -> this.createProfileDataEntity((OmObservation)observation, seriesEntity)).collect(Collectors.toList());
    }

    @Override
    public UnitEntity getUom(DatasetEntity seriesEntity) {
        SweDataRecord sweDataRecord;
        List fields;
        SweDataArray dataArray;
        SweAbstractDataComponent elementType;
        OmObservation observation;
        ObservationValue observationValue;
        GetObservationResponse observationResponse = this.getObservation(seriesEntity, null, OM_2_MIMETYPE);
        List omColl = observationResponse.getObservationCollection().toStream().collect(Collectors.toList());
        if (omColl.size() == 1 && (observationValue = (observation = (OmObservation)omColl.get(0)).getValue()).getValue() instanceof SweDataArrayValue && (elementType = (dataArray = ((SweDataArrayValue)observationValue.getValue()).getValue()).getElementType()) instanceof SweDataRecord && (fields = (sweDataRecord = (SweDataRecord)elementType).getFields()).size() == 2) {
            return this.createUnitEntity((SweField)fields.get(1), (ProxyServiceEntity)seriesEntity.getService());
        }
        return null;
    }

    private DataEntity<?> createProfileDataEntity(OmObservation observation, DatasetEntity seriesEntity) {
        ProfileDataEntity dataEntity = new ProfileDataEntity();
        ObservationValue obsValue = observation.getValue();
        Date timestamp = ((TimeInstant)obsValue.getPhenomenonTime()).getValue().toDate();
        dataEntity.setTimestart(timestamp);
        dataEntity.setTimeend(timestamp);
        ProxyServiceEntity service = (ProxyServiceEntity)seriesEntity.getService();
        Optional<Set> values = Optional.ofNullable(obsValue).map(ObservationValue::getValue).flatMap(Functions.castIfInstanceOf(SweDataArrayValue.class)).map(SweDataArrayValue::getValue).map(dataArray -> {
            SweAbstractDataComponent elementType = dataArray.getElementType();
            UnitEntity verticalUnit = Optional.ofNullable(elementType).flatMap(Functions.castIfInstanceOf(SweDataRecord.class)).map(SweAbstractDataRecord::getFields).filter(fields -> fields.size() == 2).map(fields -> this.createUnitEntity((SweField)fields.get(0), service)).orElse(null);
            return dataArray.getValues().stream().map(valueEntry -> {
                BigDecimal measurement = new BigDecimal((String)valueEntry.get(1));
                BigDecimal verticalValue = new BigDecimal((String)valueEntry.get(0));
                LOGGER.info("Value: {}, VerticalValue: {}", (Object)measurement, (Object)verticalValue);
                return this.createVerticalEntry(measurement, timestamp, verticalUnit, verticalValue);
            }).map(x -> x).collect(Collectors.toSet());
        });
        dataEntity.setValue((Object)values.orElseGet(HashSet::new));
        return dataEntity;
    }

    private UnitEntity createUnitEntity(SweField field, ProxyServiceEntity service) {
        if (!(field.getElement() instanceof SweQuantity)) {
            return null;
        }
        SweQuantity sweQuantity = (SweQuantity)field.getElement();
        String description = sweQuantity.getDefinition();
        String uom = sweQuantity.getUom();
        return EntityBuilder.createUnit(uom, description, service);
    }

    private QuantityDataEntity createVerticalEntry(BigDecimal measurement, Date timestamp, UnitEntity verticalUnit, BigDecimal verticalValue) {
        QuantityDataEntity quantityDataEntity = new QuantityDataEntity();
        quantityDataEntity.setValue((Object)measurement);
        quantityDataEntity.setTimestart(timestamp);
        quantityDataEntity.setTimeend(timestamp);
        HashSet<ParameterQuantity> parameters = new HashSet<ParameterQuantity>(1);
        ParameterQuantity parameterQuantity = new ParameterQuantity();
        parameterQuantity.setUnit(verticalUnit);
        parameterQuantity.setName("depth");
        parameterQuantity.setValue((Object)verticalValue.doubleValue());
        parameters.add(parameterQuantity);
        quantityDataEntity.setParameters(parameters);
        return quantityDataEntity;
    }

    @Override
    public Optional<DataEntity<?>> getFirstObservation(DatasetEntity entity) {
        return Optional.empty();
    }

    @Override
    public Optional<DataEntity<?>> getLastObservation(DatasetEntity entity) {
        return Optional.empty();
    }

    @Override
    protected void addDatasets(ServiceConstellation serviceConstellation, SosCapabilities sosCaps, DataSourceConfiguration config) {
        if (sosCaps != null) {
            sosCaps.getContents().ifPresent(obsOffs -> obsOffs.stream().filter(obsOff -> config.getAllowedOfferings() == null || config.getAllowedOfferings().contains(obsOff.getIdentifier())).forEach(obsOff -> this.addElem((SosObservationOffering)obsOff, serviceConstellation, config.getUrl())));
        }
    }

    private void addElem(SosObservationOffering obsOff, ServiceConstellation servConst, String url) {
        String offeringId = obsOff.getOffering().getIdentifier();
        servConst.putOffering(offeringId, offeringId);
        LOGGER.info("Harvest for Offering {} with {} procedure(s), {} observableProperperties", new Object[]{offeringId, obsOff.getProcedures().size(), obsOff.getObservableProperties().size()});
        obsOff.getProcedures().forEach(procedureId -> {
            LOGGER.info("Harvest Procedure {}", procedureId);
            SensorML sensorML = this.getDescribeSensorResponse((String)procedureId, url);
            sensorML.getMembers().forEach(member -> obsOff.getObservableProperties().forEach(obsProp -> {
                if (!obsProp.equals("sea_water_salinity") && member instanceof System) {
                    List components = ((System)member).getComponents();
                    for (int i = 0; i < components.size(); ++i) {
                        LOGGER.info("Still get " + (components.size() - i) + " components");
                        this.addElem((SmlComponent)components.get(i), (String)obsProp, offeringId, servConst, url);
                    }
                }
            }));
        });
    }

    private void addElem(SmlComponent component, String obsProp, String offeringId, ServiceConstellation servConst, String url) {
        String procedureComponentId = component.getName();
        servConst.putProcedure(procedureComponentId, procedureComponentId, true, false);
        servConst.putPhenomenon(obsProp, obsProp);
        servConst.putCategory(obsProp, obsProp);
        LOGGER.info("Send getFOI request with procedure component {} and observedProperty {}", (Object)procedureComponentId, (Object)obsProp);
        GetFeatureOfInterestResponse response = this.getFeatureOfInterest(null, procedureComponentId, obsProp, url);
        if (response.getAbstractFeature() instanceof FeatureCollection) {
            ((FeatureCollection)response.getAbstractFeature()).getMembers().forEach((key, feature) -> {
                String foiId = this.addAbstractFeature((AbstractFeature)feature, servConst);
                if (foiId != null) {
                    ProfileDatasetConstellation profileDatasetConstellation = new ProfileDatasetConstellation(procedureComponentId, offeringId, obsProp, obsProp, foiId);
                    servConst.add(profileDatasetConstellation);
                }
            });
        } else {
            String foiId = this.addAbstractFeature(response.getAbstractFeature(), servConst);
            if (foiId != null) {
                ProfileDatasetConstellation profileDatasetConstellation = new ProfileDatasetConstellation(procedureComponentId, offeringId, obsProp, obsProp, foiId);
                servConst.add(profileDatasetConstellation);
            }
        }
    }

    private String addAbstractFeature(AbstractFeature feature, ServiceConstellation servConst) {
        if (feature instanceof SamplingFeature) {
            String foiId = feature.getGmlId();
            String foiName = feature.getFirstName() != null ? feature.getFirstName().getValue() : feature.getGmlId();
            String foiDescription = feature.getDescription();
            SamplingFeature samplingFeature = (SamplingFeature)feature;
            servConst.putFeature(foiId, foiName, foiDescription, samplingFeature.getGeometry());
            return foiId;
        }
        return null;
    }

    private SensorML getDescribeSensorResponse(String procedureId, String url) {
        DescribeSensorRequest request = new DescribeSensorRequest("SOS", "2.0.0");
        request.setProcedure(procedureId);
        request.setProcedureDescriptionFormat("http://www.opengis.net/sensorML/1.0.0");
        return (SensorML)this.getSosResponseFor((OwsServiceRequest)request, "http://www.opengis.net/swes/2.0", url);
    }
}

