/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.n52.io.handler.ConfigTypedFactory;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.db.da.ProxyDataRepository;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.HibernateSessionStore;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class DataRepositoryFactory<S extends DatasetEntity, E extends DataEntity<T>, V extends AbstractValue<?>, T>
extends ConfigTypedFactory<ProxyDataRepository<S, E, V, T>>
implements DataRepositoryTypeFactory {
    private static final String DEFAULT_CONFIG_FILE = "dataset-repository-factory-proxy.properties";
    @Autowired
    private HibernateSessionStore sessionStore;
    private final Map<String, AbstractConnector> connectorMap = new HashMap<String, AbstractConnector>();

    public DataRepositoryFactory() {
        super(DEFAULT_CONFIG_FILE);
    }

    public DataRepositoryFactory(File configFile) {
        super(configFile);
    }

    @Autowired
    public void setConnectors(List<AbstractConnector> connectors) {
        connectors.forEach(connector -> this.connectorMap.put(connector.getConnectorName(), (AbstractConnector)connector));
    }

    protected ProxyDataRepository<S, E, V, T> initInstance(ProxyDataRepository<S, E, V, T> instance) {
        instance.setConnectorMap(this.connectorMap);
        if (instance instanceof SessionAwareRepository) {
            SessionAwareRepository sessionAwareRepository = (SessionAwareRepository)instance;
            sessionAwareRepository.setSessionStore(this.sessionStore);
        }
        return instance;
    }

    protected String getFallbackConfigResource() {
        return DEFAULT_CONFIG_FILE;
    }

    protected Class<ProxyDataRepository> getTargetType() {
        return ProxyDataRepository.class;
    }

    public <S extends DatasetEntity, E extends DataEntity<T>, V extends AbstractValue<?>, T> DataRepository<S, E, V, T> create(String valueType, Class<S> entityType) {
        throw new UnsupportedOperationException("create() not yet implemented");
    }

    public Class<? extends DatasetEntity> getDatasetEntityType(String valueType) {
        throw new UnsupportedOperationException("getDatasetEntityType() not yet implemented");
    }
}

