/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.beans.RelatedFeatureEntity;
import org.n52.proxy.db.beans.RelatedFeatureRoleEntity;
import org.n52.proxy.db.dao.ProxyCategoryDao;
import org.n52.proxy.db.dao.ProxyDataDao;
import org.n52.proxy.db.dao.ProxyDatasetDao;
import org.n52.proxy.db.dao.ProxyFeatureDao;
import org.n52.proxy.db.dao.ProxyOfferingDao;
import org.n52.proxy.db.dao.ProxyPhenomenonDao;
import org.n52.proxy.db.dao.ProxyProcedureDao;
import org.n52.proxy.db.dao.ProxyRelatedFeatureDao;
import org.n52.proxy.db.dao.ProxyRelatedFeatureRoleDao;
import org.n52.proxy.db.dao.ProxyServiceDao;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.SessionAwareRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertRepository
extends SessionAwareRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertRepository.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<Long> getIdsForService(ProxyServiceEntity service) {
        Session session = this.getSession();
        try {
            Set<Long> idsForService = new ProxyDatasetDao(session).getIdsForService(service);
            session.flush();
            Set<Long> set = idsForService;
            return set;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(ProxyServiceEntity service, Set<Long> datasetIds) {
        Session session = this.getSession();
        try {
            Transaction transaction = session.beginTransaction();
            new ProxyDatasetDao(session).removeDatasets(datasetIds);
            new ProxyCategoryDao(session).clearUnusedForService(service);
            new ProxyOfferingDao(session).clearUnusedForService(service);
            new ProxyProcedureDao(session).clearUnusedForService(service);
            new ProxyFeatureDao(session).clearUnusedForService(service);
            new ProxyPhenomenonDao(session).clearUnusedForService(service);
            new ProxyRelatedFeatureDao(session).clearUnusedForService(service);
            new ProxyDataDao(session).clearUnusedForService(service);
            session.flush();
            transaction.commit();
        }
        finally {
            this.returnSession(session);
        }
    }

    public void removeNonMatchingServices(Set<DataSourceConfiguration> configuredServices) {
        Session session = this.getSession();
        try {
            new ProxyServiceDao(session).getAllServices().stream().filter(service -> !this.isConfigured(configuredServices, (ProxyServiceEntity)((Object)service))).forEach(this::removeService);
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeService(ProxyServiceEntity service) {
        Session session = this.getSession();
        try {
            Transaction transaction = session.beginTransaction();
            new ProxyDatasetDao(session).removeAllOfService(service);
            new ProxyDataDao(session).clearUnusedForService(service);
            new ProxyCategoryDao(session).clearUnusedForService(service);
            new ProxyOfferingDao(session).clearUnusedForService(service);
            new ProxyProcedureDao(session).clearUnusedForService(service);
            new ProxyFeatureDao(session).clearUnusedForService(service);
            new ProxyPhenomenonDao(session).clearUnusedForService(service);
            new ProxyRelatedFeatureDao(session).clearUnusedForService(service);
            new ProxyServiceDao(session).deleteInstance(service);
            new ProxyDataDao(session).clearUnusedForService(service);
            session.flush();
            transaction.commit();
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyServiceEntity insertService(ProxyServiceEntity service) {
        Session session = this.getSession();
        try {
            Transaction transaction = session.beginTransaction();
            ProxyServiceEntity insertedService = this.insertService(service, session);
            session.flush();
            transaction.commit();
            ProxyServiceEntity proxyServiceEntity = insertedService;
            return proxyServiceEntity;
        }
        finally {
            this.returnSession(session);
        }
    }

    private ProxyServiceEntity insertService(ProxyServiceEntity service, Session session) {
        return new ProxyServiceDao(session).getOrInsertInstance(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOffering(OfferingEntity offeringEntity) {
        Session session = this.getSession();
        try {
            Transaction transaction = session.beginTransaction();
            this.insertOffering(offeringEntity, session);
            session.flush();
            transaction.commit();
        }
        finally {
            this.returnSession(session);
        }
    }

    private OfferingEntity insertOffering(OfferingEntity offering, Session session) {
        return new ProxyOfferingDao(session).getOrInsertInstance(offering);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DatasetEntity insertDataset(DatasetEntity dataset) {
        Session session = this.getSession();
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            ProcedureEntity procedure = this.insertProcedure(dataset.getProcedure(), session);
            CategoryEntity category = this.insertCategory(dataset.getCategory(), session);
            OfferingEntity offering = this.insertOffering(dataset.getOffering(), session);
            FeatureEntity feature = this.insertFeature(dataset.getFeature(), session);
            PhenomenonEntity phenomenon = this.insertPhenomenon(dataset.getPhenomenon(), session);
            DatasetEntity inserted = this.insertDataset(dataset, category, procedure, offering, feature, phenomenon, session);
            session.flush();
            transaction.commit();
            DatasetEntity datasetEntity = inserted;
            return datasetEntity;
        }
        catch (HibernateException e) {
            if (transaction != null) {
                transaction.rollback();
            }
            LOGGER.error("Error occured while saving dataset: ", (Throwable)e);
        }
        finally {
            this.returnSession(session);
        }
        return null;
    }

    private DatasetEntity insertDataset(DatasetEntity dataset, CategoryEntity category, ProcedureEntity procedure, OfferingEntity offering, FeatureEntity feature, PhenomenonEntity phenomenon, Session session) {
        dataset.setCategory(category);
        dataset.setProcedure(procedure);
        dataset.setOffering(offering);
        dataset.setFeature(feature);
        dataset.setPhenomenon(phenomenon);
        if (dataset.getUnit() != null) {
            dataset.getUnit().setService(dataset.getService());
        }
        return new ProxyDatasetDao<DatasetEntity>(session).getOrInsertInstance(dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertRelatedFeature(Collection<RelatedFeatureEntity> relatedFeatures) {
        Session session = this.getSession();
        try {
            Transaction transaction = session.beginTransaction();
            relatedFeatures.forEach(relatedFeature -> this.insertRelatedFeature((RelatedFeatureEntity)relatedFeature, session));
            session.flush();
            transaction.commit();
        }
        catch (HibernateException e) {
            LOGGER.error("Error occured while saving related feature", (Throwable)e);
        }
        finally {
            this.returnSession(session);
        }
    }

    private RelatedFeatureEntity insertRelatedFeature(RelatedFeatureEntity relatedFeature, Session session) {
        Set<RelatedFeatureRoleEntity> roles = relatedFeature.getRelatedFeatureRoles().stream().map(relatedFeatureRole -> this.insertRelatedFeatureRole((RelatedFeatureRoleEntity)relatedFeatureRole, session)).collect(Collectors.toSet());
        relatedFeature.setRelatedFeatureRoles(roles);
        Set offerings = relatedFeature.getOfferings().stream().map(offering -> this.insertOffering((OfferingEntity)offering, session)).collect(Collectors.toSet());
        relatedFeature.setOfferings(offerings);
        return new ProxyRelatedFeatureDao(session).getOrInsertInstance(relatedFeature);
    }

    private ProcedureEntity insertProcedure(ProcedureEntity procedure, Session session) {
        return new ProxyProcedureDao(session).getOrInsertInstance(procedure);
    }

    private CategoryEntity insertCategory(CategoryEntity category, Session session) {
        return new ProxyCategoryDao(session).getOrInsertInstance(category);
    }

    private FeatureEntity insertFeature(FeatureEntity feature, Session session) {
        return new ProxyFeatureDao(session).getOrInsertInstance(feature);
    }

    private PhenomenonEntity insertPhenomenon(PhenomenonEntity phenomenon, Session session) {
        return new ProxyPhenomenonDao(session).getOrInsertInstance(phenomenon);
    }

    private RelatedFeatureRoleEntity insertRelatedFeatureRole(RelatedFeatureRoleEntity relatedFeatureRole, Session session) {
        return new ProxyRelatedFeatureRoleDao(session).getOrInsertInstance(relatedFeatureRole);
    }

    protected boolean isConfigured(Set<DataSourceConfiguration> configuredServices, ProxyServiceEntity service) {
        return configuredServices.stream().anyMatch(configuration -> this.equals((DataSourceConfiguration)configuration, service));
    }

    protected boolean equals(DataSourceConfiguration configuration, ProxyServiceEntity service) {
        return configuration.getUrl().equals(service.getUrl()) && configuration.getItemName().equals(service.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertData(DatasetEntity dataset, DataEntity<?> data) {
        data.setSeriesPkid(data.getPkid());
        Session session = this.getSession();
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            new ProxyDataDao(session).getOrInsertInstance(data);
            session.flush();
            transaction.commit();
        }
        catch (HibernateException e) {
            LOGGER.error("Error occured while saving data", (Throwable)e);
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            this.returnSession(session);
        }
    }
}

