/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.proxy.db.dao.ProxyDbQuery;
import org.n52.series.db.dao.ServiceDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ProxyServiceDao
extends ServiceDao
implements InsertDao<ProxyServiceEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServiceDao.class);
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_NAME = "name";

    public ProxyServiceDao(Session session) {
        super(session);
    }

    @Override
    public ProxyServiceEntity getOrInsertInstance(ProxyServiceEntity service) {
        ProxyServiceEntity instance = this.getInstance(service);
        if (instance != null) {
            return instance;
        }
        this.session.save((Object)service);
        LOGGER.info("Save service: " + (Object)((Object)service));
        return service;
    }

    private ProxyServiceEntity getInstance(ProxyServiceEntity service) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)COLUMN_TYPE, (Object)service.getType())).add((Criterion)Restrictions.eq((String)COLUMN_URL, (Object)service.getUrl())).add((Criterion)Restrictions.eq((String)COLUMN_NAME, (Object)service.getName()));
        return (ProxyServiceEntity)((Object)criteria.uniqueResult());
    }

    public List<ProxyServiceEntity> getAllServices() {
        return this.getDefaultCriteria(ProxyDbQuery.createDefaults()).list();
    }

    public void deleteInstance(ProxyServiceEntity service) {
        this.session.delete((Object)service);
    }
}

