/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.web;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.xmlbeans.XmlObject;
import org.n52.proxy.web.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpClient
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static final ContentType CONTENT_TYPE_TEXT_XML = ContentType.create((String)"text/xml", (Charset)StandardCharsets.UTF_8);
    private static final RetryPolicy RETRY_POLICY = new RetryPolicy().retryOn(ConnectException.class).withDelay(10L, TimeUnit.SECONDS).withMaxDuration(15L, TimeUnit.MINUTES);
    private CloseableHttpClient httpclient;
    private int connectionTimeout;
    private int socketTimeout;

    public SimpleHttpClient() {
        this(30000);
    }

    public SimpleHttpClient(int connectionTimeout) {
        this(connectionTimeout, 30000);
    }

    public SimpleHttpClient(int connectionTimeout, int socketTimeout) {
        this.socketTimeout = socketTimeout;
        this.connectionTimeout = connectionTimeout;
        this.recreateClient();
    }

    protected SimpleHttpClient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }

    @Override
    public HttpResponse executeGet(String uri) throws IOException {
        LOGGER.debug("executing GET method '{}'", (Object)uri);
        return this.executeMethod((HttpRequestBase)new HttpGet(uri));
    }

    public HttpResponse executePost(String uri, XmlObject payloadToSend) throws IOException {
        return this.executePost(uri, payloadToSend.xmlText(), CONTENT_TYPE_TEXT_XML);
    }

    @Override
    public HttpResponse executePost(String uri, String payloadToSend) throws IOException {
        return this.executePost(uri, payloadToSend, CONTENT_TYPE_TEXT_XML);
    }

    @Override
    public HttpResponse executePost(String uri, String payloadToSend, ContentType contentType) throws IOException {
        StringEntity requestEntity = new StringEntity(payloadToSend, contentType);
        LOGGER.trace("payload to send: {}", (Object)payloadToSend);
        return this.executePost(uri, (HttpEntity)requestEntity);
    }

    @Override
    public HttpResponse executePost(String uri, HttpEntity payloadToSend) throws IOException {
        LOGGER.debug("executing POST method to '{}'.", (Object)uri);
        HttpPost post = new HttpPost(uri);
        post.setEntity(payloadToSend);
        return this.executeMethod((HttpRequestBase)post);
    }

    @Override
    public HttpResponse executeMethod(HttpRequestBase method) throws IOException {
        return (HttpResponse)((SyncFailsafe)Failsafe.with((RetryPolicy)RETRY_POLICY).onFailedAttempt(ex -> LOGGER.warn("Could not connect to host; retrying", ex))).get(() -> this.httpclient.execute((HttpUriRequest)method));
    }

    public void setConnectionTimout(int timeout) {
        this.connectionTimeout = timeout;
        this.recreateClient();
    }

    public void setSocketTimout(int timeout) {
        this.socketTimeout = timeout;
        this.recreateClient();
    }

    private void recreateClient() {
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Error closing client", (Throwable)ex);
            }
            this.httpclient = null;
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.socketTimeout).build();
        this.httpclient = HttpClientBuilder.create().useSystemProperties().setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).build();
    }
}

