/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.n52.proxy.db.dao.ClearDao;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.proxy.db.dao.ProxyDbQuery;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.dao.DataDao;

public class ProxyDataDao<T extends DataEntity<?>>
extends DataDao<T>
implements ClearDao<T>,
InsertDao<DataEntity<?>> {
    public ProxyDataDao(Session session) {
        super(session);
    }

    public ProxyDataDao(Session session, Class<T> clazz) {
        super(session, clazz);
    }

    public Long getObservationCount(DatasetEntity entity) {
        return (Long)this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add((Criterion)Restrictions.eq((String)"seriesPkid", (Object)entity.getPkid())).setProjection(Projections.rowCount()).uniqueResult();
    }

    @Override
    public void clearUnusedForService(ServiceEntity service) {
        DetachedCriteria existingDatasetIds = DetachedCriteria.forClass(DatasetEntity.class).setProjection(Projections.distinct((Projection)Projections.property((String)"pkid")));
        DetachedCriteria minTimeByDataset = DetachedCriteria.forClass(DataEntity.class).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"seriesPkid")).add((Projection)Projections.min((String)"resultTime")));
        DetachedCriteria maxTimeByDataset = DetachedCriteria.forClass(DataEntity.class).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"seriesPkid")).add((Projection)Projections.max((String)"resultTime")));
        Criterion notExistingDataset = Subqueries.propertyNotIn((String)"seriesPkid", (DetachedCriteria)existingDatasetIds);
        Criterion notFirstData = Subqueries.propertiesNotIn((String[])new String[]{"seriesPkid", "resultTime"}, (DetachedCriteria)minTimeByDataset);
        Criterion notLatestData = Subqueries.propertiesNotIn((String[])new String[]{"seriesPkid", "resultTime"}, (DetachedCriteria)maxTimeByDataset);
        this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.or((Criterion)notExistingDataset, (Criterion)Restrictions.and((Criterion)notFirstData, (Criterion)notLatestData))).list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
    }

    @Override
    public DataEntity<?> getOrInsertInstance(DataEntity<?> object) {
        DataEntity<?> instance = this.getInstance(object);
        if (instance != null) {
            return instance;
        }
        this.session.save(object);
        return object;
    }

    protected DataEntity<?> getInstance(DataEntity<?> object) throws HibernateException {
        return (DataEntity)this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)"seriesPkid", (Object)object.getSeriesPkid())).add((Criterion)Restrictions.eq((String)"timestart", (Object)object.getTimestart())).add(Restrictions.eqOrIsNull((String)"timeend", (Object)object.getTimeend())).add(Restrictions.eqOrIsNull((String)"resultTime", (Object)object.getResultTime())).uniqueResult();
    }
}

