/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.math.BigDecimal;
import java.util.Map;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.da.ProxyDataRepository;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.dao.DbQuery;

public class ProxyQuantityDataRepository
extends QuantityDataRepository
implements ProxyDataRepository<QuantityDatasetEntity, QuantityDataEntity, QuantityValue, BigDecimal> {
    private Map<String, AbstractConnector> connectorMap;

    @Override
    public void setConnectorMap(Map<String, AbstractConnector> connectorMap) {
        this.connectorMap = connectorMap;
    }

    private AbstractConnector getConnector(QuantityDatasetEntity seriesEntity) {
        String connectorName = ((ProxyServiceEntity)seriesEntity.getService()).getConnector();
        return this.connectorMap.get(connectorName);
    }

    public QuantityValue getFirstValue(QuantityDatasetEntity entity, Session session, DbQuery query) {
        DataEntity firstObservation = this.getConnector(entity).getFirstObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((QuantityDataEntity)firstObservation, entity, query);
    }

    public QuantityValue getLastValue(QuantityDatasetEntity entity, Session session, DbQuery query) {
        DataEntity lastObservation = this.getConnector(entity).getLastObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((QuantityDataEntity)lastObservation, entity, query);
    }

    protected Data<QuantityValue> assembleData(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        this.getConnector(seriesEntity).getObservations((DatasetEntity)seriesEntity, query).stream().map(entry -> this.assembleDataValue((QuantityDataEntity)entry, seriesEntity, query)).forEach(entry -> result.addNewValue((AbstractValue)entry));
        return result;
    }
}

