/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.proxy.db.dao.ProxyDbQuery;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.dao.DatasetDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDatasetDao<T extends DatasetEntity>
extends DatasetDao<T>
implements InsertDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyDatasetDao.class);
    private static final String COLUMN_VALUETYPE = "valueType";
    private static final String COLUMN_SERVICE_PKID = "service.pkid";
    private static final String COLUMN_CATEGORY_PKID = "category.pkid";
    private static final String COLUMN_FEATURE_PKID = "feature.pkid";
    private static final String COLUMN_PROCEDURE_PKID = "procedure.pkid";
    private static final String COLUMN_PHENOMENON_PKID = "phenomenon.pkid";
    private static final String COLUMN_OFFERING_PKID = "offering.pkid";

    public ProxyDatasetDao(Session session) {
        super(session);
    }

    public ProxyDatasetDao(Session session, Class<T> clazz) {
        super(session, clazz);
    }

    @Override
    public T getOrInsertInstance(T dataset) {
        T instance;
        if (dataset.getUnit() != null) {
            dataset.setUnit(this.getOrInsertUnit(dataset.getUnit()));
        }
        if ((instance = this.getInstance(dataset)) == null) {
            this.session.save(dataset);
            LOGGER.info("Save dataset: " + dataset);
            this.session.flush();
            this.session.refresh(dataset);
            return dataset;
        }
        return instance;
    }

    public UnitEntity getOrInsertUnit(UnitEntity unit) {
        UnitEntity instance = this.getUnit(unit);
        if (instance == null) {
            this.session.save((Object)unit);
            instance = unit;
        }
        return instance;
    }

    public Set<Long> getIdsForService(ProxyServiceEntity service) {
        return this.getDatasetsForService(service).stream().map(DescribableEntity::getPkid).collect(Collectors.toSet());
    }

    public void removeDatasets(Set<Long> datasetIds) {
        datasetIds.forEach(id -> this.session.delete(this.session.get(DatasetEntity.class, (Serializable)id)));
        this.session.flush();
    }

    public void removeAllOfService(ProxyServiceEntity service) {
        this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)service.getPkid())).list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
        this.session.createCriteria(UnitEntity.class).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)service.getPkid())).list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
        this.session.flush();
    }

    private UnitEntity getUnit(UnitEntity unit) {
        Criteria criteria = this.session.createCriteria(UnitEntity.class).add((Criterion)Restrictions.eq((String)"name", (Object)unit.getName())).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)unit.getService().getPkid()));
        return (UnitEntity)criteria.uniqueResult();
    }

    private T getInstance(T dataset) {
        Criteria criteria = this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add((Criterion)Restrictions.eq((String)COLUMN_VALUETYPE, (Object)dataset.getValueType())).add((Criterion)Restrictions.eq((String)COLUMN_CATEGORY_PKID, (Object)dataset.getCategory().getPkid())).add((Criterion)Restrictions.eq((String)COLUMN_FEATURE_PKID, (Object)dataset.getFeature().getPkid())).add((Criterion)Restrictions.eq((String)COLUMN_PROCEDURE_PKID, (Object)dataset.getProcedure().getPkid())).add((Criterion)Restrictions.eq((String)COLUMN_PHENOMENON_PKID, (Object)dataset.getPhenomenon().getPkid())).add((Criterion)Restrictions.eq((String)COLUMN_OFFERING_PKID, (Object)dataset.getOffering().getPkid())).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)dataset.getService().getPkid()));
        return (T)((DatasetEntity)criteria.uniqueResult());
    }

    private List<T> getDatasetsForService(ServiceEntity service) {
        Criteria criteria = this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)service.getPkid()));
        return criteria.list();
    }
}

