/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.n52.proxy.db.dao.ClearDao;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.dao.PhenomenonDao;

public class ProxyPhenomenonDao
extends PhenomenonDao
implements InsertDao<PhenomenonEntity>,
ClearDao<PhenomenonEntity> {
    private static final String COLUMN_SERVICE_PKID = "service.pkid";

    public ProxyPhenomenonDao(Session session) {
        super(session);
    }

    @Override
    public PhenomenonEntity getOrInsertInstance(PhenomenonEntity phenomenon) {
        PhenomenonEntity instance = this.getInstance(phenomenon);
        if (instance != null) {
            return instance;
        }
        this.session.save((Object)phenomenon);
        return phenomenon;
    }

    @Override
    public void clearUnusedForService(ServiceEntity service) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)service.getPkid())).add(Subqueries.propertyNotIn((String)"pkid", (DetachedCriteria)this.createDetachedDatasetFilter()));
        criteria.list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
    }

    private PhenomenonEntity getInstance(PhenomenonEntity phenomenon) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)"domainId", (Object)phenomenon.getDomainId())).add((Criterion)Restrictions.eq((String)COLUMN_SERVICE_PKID, (Object)phenomenon.getService().getPkid()));
        return (PhenomenonEntity)criteria.uniqueResult();
    }

    private DetachedCriteria createDetachedDatasetFilter() {
        return DetachedCriteria.forClass(DatasetEntity.class).setProjection(Projections.distinct((Projection)Projections.property((String)this.getDatasetProperty())));
    }
}

