/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.n52.janmayen.Stopwatch;
import org.n52.janmayen.function.Functions;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.connector.AbstractSosConnector;
import org.n52.proxy.connector.constellations.QuantityDatasetConstellation;
import org.n52.proxy.connector.utils.EntityBuilder;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.OwsServiceProvider;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class TrajectorySOSConnector
extends AbstractSosConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrajectorySOSConnector.class);

    @Override
    protected boolean canHandle(DataSourceConfiguration config, GetCapabilitiesResponse response) {
        return response.getCapabilities().getVersion().equals("2.0.0") && response.getCapabilities().getServiceProvider().map(OwsServiceProvider::getProviderName).filter(name -> name.equals("52North")).isPresent();
    }

    @Override
    public ServiceConstellation getConstellation(DataSourceConfiguration config, GetCapabilitiesResponse capabilities) {
        ServiceConstellation serviceConstellation = new ServiceConstellation();
        config.setVersion("2.0.0");
        config.setConnector(this.getConnectorName());
        this.addService(config, serviceConstellation);
        SosCapabilities sosCaps = (SosCapabilities)capabilities.getCapabilities();
        this.addDatasets(serviceConstellation, sosCaps, config.getUrl());
        return serviceConstellation;
    }

    @Override
    public List<DataEntity<?>> getObservations(DatasetEntity seriesEntity, DbQuery query) {
        Stopwatch stopwatch = new Stopwatch().start();
        LOGGER.info("Start GetObs request");
        GetObservationResponse obsResp = this.createObservationResponse(seriesEntity, null);
        LOGGER.info("Process GetObs response");
        List<DataEntity<?>> data = obsResp.getObservationCollection().toStream().map(Functions.currySecond(this::createDataEntity, (Object)seriesEntity)).collect(Collectors.toList());
        LOGGER.info("Found {}  Entries", (Object)data.size());
        LOGGER.info("End GetObs request in {}", (Object)stopwatch);
        return data;
    }

    @Override
    public UnitEntity getUom(DatasetEntity seriesEntity) {
        GetDataAvailabilityResponse availabilityResponse = this.getDataAvailability(seriesEntity);
        if (availabilityResponse.getDataAvailabilities().size() == 1) {
            DateTime start = ((GetDataAvailabilityResponse.DataAvailability)availabilityResponse.getDataAvailabilities().get(0)).getPhenomenonTime().getStart();
            GetObservationResponse response = this.createObservationResponse(seriesEntity, this.createTimeFilter(start));
            return response.getObservationCollection().toStream().findFirst().map(OmObservation::getValue).map(ObservationValue::getValue).map(v -> v.getUnit()).map(unit -> EntityBuilder.createUnit(unit, null, (ProxyServiceEntity)seriesEntity.getService())).orElse(null);
        }
        return null;
    }

    @Override
    public Optional<DataEntity<?>> getFirstObservation(DatasetEntity entity) {
        QuantityDataEntity quantityDataEntity = new QuantityDataEntity();
        quantityDataEntity.setTimestart(new Date());
        quantityDataEntity.setTimeend(new Date());
        quantityDataEntity.setValue((Object)BigDecimal.ZERO);
        return Optional.of(quantityDataEntity);
    }

    @Override
    public Optional<DataEntity<?>> getLastObservation(DatasetEntity entity) {
        QuantityDataEntity quantityDataEntity = new QuantityDataEntity();
        quantityDataEntity.setTimestart(new Date());
        quantityDataEntity.setTimeend(new Date());
        quantityDataEntity.setValue((Object)BigDecimal.ZERO);
        return Optional.of(quantityDataEntity);
    }

    private void addDatasets(ServiceConstellation serviceConstellation, SosCapabilities sosCaps, String serviceUri) {
        if (sosCaps != null) {
            sosCaps.getContents().ifPresent(obsOffs -> this.doForOffering((SosObservationOffering)obsOffs.first(), serviceConstellation, serviceUri));
        }
    }

    private void doForOffering(SosObservationOffering offering, ServiceConstellation serviceConstellation, String serviceUri) {
        String offeringId = this.addOffering(offering, serviceConstellation);
        this.doDataAvailability((String)offering.getObservableProperties().first(), (String)offering.getProcedures().first(), offeringId, serviceUri, serviceConstellation);
    }

    private void doDataAvailability(String obsProp, String procedureId, String offeringId, String serviceUri, ServiceConstellation serviceConstellation) {
        GetDataAvailabilityResponse gdaResponse = this.getDataAvailability(procedureId, offeringId, obsProp, null, serviceUri);
        gdaResponse.getDataAvailabilities().forEach(dataAval -> {
            String featureId = this.addFeature((GetDataAvailabilityResponse.DataAvailability)dataAval, serviceConstellation);
            this.addProcedure((GetDataAvailabilityResponse.DataAvailability)dataAval, true, true, serviceConstellation);
            String phenomenonId = this.addPhenomenon((GetDataAvailabilityResponse.DataAvailability)dataAval, serviceConstellation);
            String categoryId = this.addCategory((GetDataAvailabilityResponse.DataAvailability)dataAval, serviceConstellation);
            serviceConstellation.add(new QuantityDatasetConstellation(procedureId, offeringId, categoryId, phenomenonId, featureId));
        });
    }

    private String addFeature(GetDataAvailabilityResponse.DataAvailability dataAval, ServiceConstellation serviceConstellation) {
        String featureId = dataAval.getFeatureOfInterest().getHref();
        String featureName = dataAval.getFeatureOfInterest().getTitle();
        serviceConstellation.putFeature(featureId, featureName, null, 0.0, 0.0, 0);
        return featureId;
    }

    private GetObservationResponse createObservationResponse(DatasetEntity seriesEntity, TemporalFilter temporalFilter) {
        String responseFormat = null;
        return this.getObservation(seriesEntity, temporalFilter, responseFormat);
    }
}

