/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.connector.utils.EntityBuilder;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.da.DatasetRepository;
import org.n52.series.db.dao.DbQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ProxyDatasetRepository<V extends AbstractValue<?>>
extends DatasetRepository<V> {
    private final Map<String, AbstractConnector> connectorMap = new HashMap<String, AbstractConnector>();

    @Autowired
    public void setConnectors(List<AbstractConnector> connectors) {
        connectors.forEach(connector -> this.connectorMap.put(connector.getConnectorName(), (AbstractConnector)connector));
    }

    protected DatasetOutput createExpanded(DatasetEntity series, DbQuery query, Session session) throws DataAccessException {
        if (series.getUnit() == null || Strings.isNullOrEmpty((String)series.getUnit().getName())) {
            ProxyServiceEntity service = (ProxyServiceEntity)series.getService();
            String connectorName = service.getConnector();
            AbstractConnector connector = this.connectorMap.get(connectorName);
            UnitEntity unit = connector.getUom(series);
            if (unit == null) {
                unit = EntityBuilder.createUnit("", null, service);
            }
            series.setUnit(unit);
            session.save((Object)unit);
            session.save((Object)series);
            session.flush();
        }
        return super.createExpanded(series, query, session);
    }
}

