/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.dao.DbQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ProxyQuantityDataRepository
extends QuantityDataRepository {
    private Map<String, AbstractConnector> connectorMap;

    @Autowired
    public void setConnectors(List<AbstractConnector> connectors) {
        this.connectorMap = connectors.stream().collect(Collectors.toMap(AbstractConnector::getConnectorName, Function.identity()));
    }

    private AbstractConnector getConnector(QuantityDatasetEntity seriesEntity) {
        String connectorName = ((ProxyServiceEntity)seriesEntity.getService()).getConnector();
        return this.connectorMap.get(connectorName);
    }

    public QuantityValue getFirstValue(QuantityDatasetEntity entity, Session session, DbQuery query) {
        DataEntity firstObservation = this.getConnector(entity).getFirstObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((QuantityDataEntity)firstObservation, entity, query);
    }

    public QuantityValue getLastValue(QuantityDatasetEntity entity, Session session, DbQuery query) {
        DataEntity lastObservation = this.getConnector(entity).getLastObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((QuantityDataEntity)lastObservation, entity, query);
    }

    protected Data<QuantityValue> assembleData(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        this.getConnector(seriesEntity).getObservations((DatasetEntity)seriesEntity, query).stream().map(entry -> this.assembleDataValue((QuantityDataEntity)entry, seriesEntity, query)).forEach(entry -> result.addNewValue((AbstractValue)entry));
        return result;
    }
}

