/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.text.TextValue;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.beans.TextDatasetEntity;
import org.n52.series.db.da.TextDataRepository;
import org.n52.series.db.dao.DbQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ProxyTextDataRepository
extends TextDataRepository {
    private Map<String, AbstractConnector> connectorMap;

    @Autowired
    public void setConnectors(List<AbstractConnector> connectors) {
        this.connectorMap = connectors.stream().collect(Collectors.toMap(AbstractConnector::getConnectorName, Function.identity()));
    }

    public TextValue getFirstValue(TextDatasetEntity entity, Session session, DbQuery query) {
        DataEntity firstObs = this.getConnector(entity).getFirstObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((TextDataEntity)firstObs, entity, query);
    }

    public TextValue getLastValue(TextDatasetEntity entity, Session session, DbQuery query) {
        DataEntity lastObs = this.getConnector(entity).getLastObservation((DatasetEntity)entity).orElse(null);
        return this.assembleDataValue((TextDataEntity)lastObs, entity, query);
    }

    protected Data<TextValue> assembleData(TextDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        this.getConnector(seriesEntity).getObservations((DatasetEntity)seriesEntity, query).stream().map(entry -> this.assembleDataValue((TextDataEntity)entry, seriesEntity, query)).forEach(entry -> result.addNewValue((AbstractValue)entry));
        return result;
    }

    private AbstractConnector getConnector(TextDatasetEntity entity) {
        String connectorName = ((ProxyServiceEntity)entity.getService()).getConnector();
        return this.connectorMap.get(connectorName);
    }
}

