/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.n52.proxy.db.dao.ClearDao;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.proxy.db.dao.ProxyDbQuery;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.dao.OfferingDao;

public class ProxyOfferingDao
extends OfferingDao
implements InsertDao<OfferingEntity>,
ClearDao<OfferingEntity> {
    public ProxyOfferingDao(Session session) {
        super(session);
    }

    @Override
    public OfferingEntity getOrInsertInstance(OfferingEntity offering) {
        OfferingEntity instance = this.getInstance(offering);
        if (instance != null) {
            return instance;
        }
        this.session.save((Object)offering);
        this.session.flush();
        return offering;
    }

    @Override
    public void clearUnusedForService(ServiceEntity service) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)"service", (Object)service)).add(Subqueries.propertyNotIn((String)"pkid", (DetachedCriteria)this.createDetachedDatasetFilter()));
        criteria.list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
    }

    private OfferingEntity getInstance(OfferingEntity offering) {
        return (OfferingEntity)this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)"domainId", (Object)offering.getDomainId())).add((Criterion)Restrictions.eq((String)"service", (Object)offering.getService())).uniqueResult();
    }

    private DetachedCriteria createDetachedDatasetFilter() {
        return DetachedCriteria.forClass(DatasetEntity.class).setProjection(Projections.distinct((Projection)Projections.property((String)this.getDatasetProperty())));
    }

    public List<OfferingEntity> getInstancesFor(Collection<String> domainIds) {
        return this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add(Restrictions.in((String)"domainId", domainIds)).list();
    }
}

