/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.n52.proxy.db.dao.ClearDao;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.dao.ProcedureDao;

public class ProxyProcedureDao
extends ProcedureDao
implements InsertDao<ProcedureEntity>,
ClearDao<ProcedureEntity> {
    public ProxyProcedureDao(Session session) {
        super(session);
    }

    @Override
    public ProcedureEntity getOrInsertInstance(ProcedureEntity procedure) {
        ProcedureEntity instance = this.getInstance(procedure);
        if (instance != null) {
            return instance;
        }
        this.session.save((Object)procedure);
        this.session.flush();
        return procedure;
    }

    @Override
    public void clearUnusedForService(ServiceEntity service) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)"service", (Object)service)).add(Subqueries.propertyNotIn((String)"pkid", (DetachedCriteria)this.createDetachedDatasetFilter()));
        criteria.list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
    }

    private ProcedureEntity getInstance(ProcedureEntity procedure) {
        Criteria criteria = this.session.createCriteria(this.getEntityClass()).add((Criterion)Restrictions.eq((String)"domainId", (Object)procedure.getDomainId())).add((Criterion)Restrictions.eq((String)"service", (Object)procedure.getService()));
        return (ProcedureEntity)criteria.uniqueResult();
    }

    private DetachedCriteria createDetachedDatasetFilter() {
        return DetachedCriteria.forClass(DatasetEntity.class).setProjection(Projections.distinct((Projection)Projections.property((String)this.getDatasetProperty())));
    }
}

