/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.n52.janmayen.function.Functions;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.connector.AbstractSosConnector;
import org.n52.proxy.connector.constellations.QuantityDatasetConstellation;
import org.n52.proxy.connector.utils.EntityBuilder;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.ogc.sos.response.GetFeatureOfInterestResponse;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class SOS2Connector
extends AbstractSosConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOS2Connector.class);

    @Override
    protected boolean canHandle(DataSourceConfiguration config, GetCapabilitiesResponse response) {
        OwsCapabilities capabilities = response.getCapabilities();
        return capabilities.getVersion().equals("2.0.0") && capabilities.getServiceProvider().isPresent() && this.supportsGDA(capabilities);
    }

    @Override
    public ServiceConstellation getConstellation(DataSourceConfiguration config, GetCapabilitiesResponse capabilities) {
        ServiceConstellation serviceConstellation = new ServiceConstellation();
        config.setVersion("2.0.0");
        config.setConnector(this.getConnectorName());
        this.addService(config, serviceConstellation);
        SosCapabilities sosCaps = (SosCapabilities)capabilities.getCapabilities();
        this.addDatasets(serviceConstellation, sosCaps, config);
        LOGGER.info("{} requests were sended to harvest the service {}", (Object)this.counter, (Object)config.getItemName());
        return serviceConstellation;
    }

    @Override
    public List<DataEntity<?>> getObservations(DatasetEntity seriesEntity, DbQuery query) {
        List<DataEntity<?>> data = this.getObservation(seriesEntity, this.createTimeFilter(query)).getObservationCollection().toStream().map(Functions.currySecond(this::createDataEntity, (Object)seriesEntity)).collect(Collectors.toList());
        LOGGER.info("Found {} Entries", (Object)data.size());
        return data;
    }

    @Override
    public Optional<DataEntity<?>> getFirstObservation(DatasetEntity entity) {
        return this.getObservation(entity, this.createFirstTimefilter()).getObservationCollection().toStream().findFirst().map(obs -> this.createDataEntity((OmObservation)obs, entity));
    }

    @Override
    public Optional<DataEntity<?>> getLastObservation(DatasetEntity entity) {
        return this.getObservation(entity, this.createLatestTimefilter()).getObservationCollection().toStream().findFirst().map(obs -> this.createDataEntity((OmObservation)obs, entity));
    }

    @Override
    public UnitEntity getUom(DatasetEntity seriesEntity) {
        GetObservationResponse response = this.getObservation(seriesEntity, this.createFirstTimefilter());
        return response.getObservationCollection().toStream().findFirst().map(o -> o.getValue().getValue().getUnit()).map(unit -> EntityBuilder.createUnit(unit, null, (ProxyServiceEntity)seriesEntity.getService())).orElse(null);
    }

    protected void addDatasets(ServiceConstellation serviceConstellation, SosCapabilities sosCaps, DataSourceConfiguration config) {
        sosCaps.getContents().ifPresent(contents -> contents.forEach(sosObsOff -> this.doForOffering((SosObservationOffering)sosObsOff, serviceConstellation, config)));
    }

    protected void doForOffering(SosObservationOffering offering, ServiceConstellation serviceConstellation, DataSourceConfiguration config) {
        String offeringId = this.addOffering(offering, serviceConstellation);
        offering.getProcedures().forEach(procedureId -> {
            this.addProcedure((String)procedureId, true, false, serviceConstellation);
            GetFeatureOfInterestResponse foiResponse = this.getFeatureOfInterestByProcedure((String)procedureId, config.getUrl());
            this.addFeature(foiResponse.getAbstractFeature(), serviceConstellation);
            GetDataAvailabilityResponse gdaResponse = this.getDataAvailabilityByProcedure((String)procedureId, config.getUrl());
            if (gdaResponse != null) {
                gdaResponse.getDataAvailabilities().forEach(dataAval -> {
                    String phenomenonId = this.addPhenomenon((GetDataAvailabilityResponse.DataAvailability)dataAval, serviceConstellation);
                    String categoryId = this.addCategory((GetDataAvailabilityResponse.DataAvailability)dataAval, serviceConstellation);
                    String featureId = dataAval.getFeatureOfInterest().getHref();
                    serviceConstellation.add(new QuantityDatasetConstellation((String)procedureId, offeringId, categoryId, phenomenonId, featureId));
                });
            }
            LOGGER.info(foiResponse.toString());
        });
    }
}

