/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector;

import com.google.common.primitives.Ints;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.connector.utils.EntityBuilder;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.web.SimpleHttpClient;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.JTSGeometryConverter;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.sos.ExtendedIndeterminateTime;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConnector.class);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long SOCKET_TIMEOUT = TimeUnit.MINUTES.toMillis(30L);
    private final SimpleHttpClient httpClient = new SimpleHttpClient(Ints.checkedCast((long)CONNECTION_TIMEOUT), Ints.checkedCast((long)SOCKET_TIMEOUT));

    public String getConnectorName() {
        return this.getClass().getName();
    }

    protected HttpResponse sendGetRequest(String uri) throws IOException {
        LOGGER.debug("Executing GET request {}", (Object)uri);
        return this.httpClient.executeGet(uri);
    }

    protected HttpResponse sendPostRequest(XmlObject request, String uri) throws IOException {
        LOGGER.debug("Executing POST request to {}\n{}", (Object)uri, (Object)request.xmlText());
        return this.httpClient.executePost(uri, request);
    }

    public abstract List<DataEntity<?>> getObservations(DatasetEntity var1, DbQuery var2);

    public abstract UnitEntity getUom(DatasetEntity var1);

    public abstract Optional<DataEntity<?>> getFirstObservation(DatasetEntity var1);

    public abstract Optional<DataEntity<?>> getLastObservation(DatasetEntity var1);

    protected void addService(DataSourceConfiguration config, ServiceConstellation serviceConstellation) {
        ProxyServiceEntity service = EntityBuilder.createService(config.getItemName(), "here goes description", config.getConnector(), config.getUrl(), config.getVersion());
        serviceConstellation.setService(service);
    }

    protected String addOffering(SosObservationOffering offering, ServiceConstellation serviceConstellation) {
        String offeringId = offering.getIdentifier();
        CodeType name = offering.getFirstName();
        if (name != null) {
            serviceConstellation.putOffering(offeringId, name.getValue());
        } else {
            serviceConstellation.putOffering(offeringId, offeringId);
        }
        return offeringId;
    }

    protected String addOffering(ReferenceType offering, ServiceConstellation serviceConstellation) {
        String offeringId = offering.getHref();
        String offeringName = offering.getTitle();
        serviceConstellation.putOffering(offeringId, offeringName);
        return offeringId;
    }

    protected String addOffering(String offeringId, String offeringName, ServiceConstellation serviceConstellation) {
        serviceConstellation.putOffering(offeringId, offeringName);
        return offeringId;
    }

    protected String addProcedure(String procedureId, boolean insitu, boolean mobile, ServiceConstellation serviceConstellation) {
        serviceConstellation.putProcedure(procedureId, procedureId, insitu, mobile);
        return procedureId;
    }

    protected String addProcedure(GetDataAvailabilityResponse.DataAvailability dataAval, boolean insitu, boolean mobile, ServiceConstellation serviceConstellation) {
        String procedureId = dataAval.getProcedure().getHref();
        String procedureName = dataAval.getProcedure().getTitle();
        serviceConstellation.putProcedure(procedureId, procedureName, insitu, mobile);
        return procedureId;
    }

    protected String addProcedure(String procedureId, String procedureName, boolean insitu, boolean mobile, ServiceConstellation serviceConstellation) {
        serviceConstellation.putProcedure(procedureId, procedureName, insitu, mobile);
        return procedureId;
    }

    protected String addPhenomenon(String phenomenonId, ServiceConstellation serviceConstellation) {
        serviceConstellation.putPhenomenon(phenomenonId, phenomenonId);
        return phenomenonId;
    }

    protected String addPhenomenon(String phenomenonId, String phenomenonName, ServiceConstellation serviceConstellation) {
        serviceConstellation.putPhenomenon(phenomenonId, phenomenonName);
        return phenomenonId;
    }

    protected String addPhenomenon(GetDataAvailabilityResponse.DataAvailability dataAval, ServiceConstellation serviceConstellation) {
        String phenomenonId = dataAval.getObservedProperty().getHref();
        String phenomenonName = dataAval.getObservedProperty().getTitle();
        serviceConstellation.putPhenomenon(phenomenonId, phenomenonName);
        return phenomenonId;
    }

    protected String addCategory(String categoryId, ServiceConstellation serviceConstellation) {
        serviceConstellation.putCategory(categoryId, categoryId);
        return categoryId;
    }

    protected String addCategory(GetDataAvailabilityResponse.DataAvailability dataAval, ServiceConstellation serviceConstellation) {
        String categoryId = dataAval.getObservedProperty().getHref();
        String categoryName = dataAval.getObservedProperty().getTitle();
        serviceConstellation.putCategory(categoryId, categoryName);
        return categoryId;
    }

    protected String addCategory(String categoryId, String categoryName, ServiceConstellation serviceConstellation) {
        serviceConstellation.putCategory(categoryId, categoryName);
        return categoryId;
    }

    protected void addFeature(AbstractFeature feature, ServiceConstellation serviceConstellation) {
        if (feature instanceof SamplingFeature) {
            this.addFeature((SamplingFeature)feature, serviceConstellation);
        } else if (feature instanceof FeatureCollection) {
            ((FeatureCollection)feature).forEach(featureEntry -> this.addFeature((AbstractFeature)featureEntry, serviceConstellation));
        }
    }

    protected String addFeature(SamplingFeature samplingfeature, ServiceConstellation serviceConstellation) {
        String featureName;
        String featureId = samplingfeature.getIdentifier();
        String featureDescription = samplingfeature.getDescription();
        String string = featureName = samplingfeature.getFirstName() != null ? samplingfeature.getFirstName().getValue() : featureId;
        if (samplingfeature.getGeometry() != null) {
            serviceConstellation.putFeature(featureId, featureName, featureDescription, samplingfeature.getGeometry());
        } else {
            LOGGER.warn("No geometry found");
        }
        return featureId;
    }

    protected TemporalFilter createFirstTimefilter() {
        return new TemporalFilter(FilterConstants.TimeOperator.TM_Equals, (Time)new TimeInstant(ExtendedIndeterminateTime.FIRST), "phenomenonTime");
    }

    protected TemporalFilter createLatestTimefilter() {
        return new TemporalFilter(FilterConstants.TimeOperator.TM_Equals, (Time)new TimeInstant(ExtendedIndeterminateTime.LATEST), "phenomenonTime");
    }

    protected TemporalFilter createTimeFilter(DbQuery query) {
        return this.createTimeFilter(query.getTimespan());
    }

    protected TemporalFilter createTimeFilter(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        TimeInstant instant = new TimeInstant(dateTime);
        FilterConstants.TimeOperator operator = FilterConstants.TimeOperator.TM_Equals;
        String valueReference = "phenomenonTime";
        return new TemporalFilter(operator, (Time)instant, valueReference);
    }

    protected TemporalFilter createTimeFilter(Interval timespan) {
        if (timespan == null) {
            return null;
        }
        if (timespan.toDurationMillis() == 0L) {
            return this.createTimeFilter(timespan.getStart());
        }
        String valueReference = "phenomenonTime";
        FilterConstants.TimeOperator operator = FilterConstants.TimeOperator.TM_During;
        TimePeriod period = new TimePeriod(timespan);
        return new TemporalFilter(operator, (Time)period, valueReference);
    }

    protected SpatialFilter createSpatialFilter(DbQuery query) {
        return this.createSpatialFilter(query.getSpatialFilter());
    }

    protected SpatialFilter createSpatialFilter(Envelope envelope) {
        return this.createSpatialFilter(envelope, 4326);
    }

    protected SpatialFilter createSpatialFilter(Envelope envelope, int srid) {
        if (envelope == null) {
            return null;
        }
        Geometry geom = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid).toGeometry(envelope);
        String valueReference = "http://www.opengis.net/req/omxml/2.0/data/samplingGeometry";
        return new SpatialFilter(FilterConstants.SpatialOperator.BBOX, JTSGeometryConverter.convert((Geometry)geom), valueReference);
    }
}

