/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector.utils;

import java.math.BigDecimal;
import java.util.Optional;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.dao.JTSGeometryConverter;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.values.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataEntityBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataEntityBuilder.class);

    private DataEntityBuilder() {
    }

    public static DataEntity<BigDecimal> createQuantityDataEntity(OmObservation observation) {
        QuantityDataEntity dataEntity = new QuantityDataEntity();
        DataEntityBuilder.getNumericValue(observation).map(x -> {
            if (x instanceof BigDecimal) {
                return (BigDecimal)x;
            }
            return BigDecimal.valueOf(x.doubleValue());
        }).ifPresent(arg_0 -> ((QuantityDataEntity)dataEntity).setValue(arg_0));
        return DataEntityBuilder.setCommonValues(observation, dataEntity);
    }

    public static DataEntity<Integer> createCountDataEntity(OmObservation observation) {
        CountDataEntity dataEntity = new CountDataEntity();
        DataEntityBuilder.getNumericValue(observation).map(Number::intValue).ifPresent(arg_0 -> ((CountDataEntity)dataEntity).setValue(arg_0));
        return DataEntityBuilder.setCommonValues(observation, dataEntity);
    }

    public static DataEntity<String> createTextDataEntity(OmObservation observation) {
        TextDataEntity dataEntity = new TextDataEntity();
        DataEntityBuilder.getStringValue(observation).ifPresent(arg_0 -> ((TextDataEntity)dataEntity).setValue(arg_0));
        return DataEntityBuilder.setCommonValues(observation, dataEntity);
    }

    private static Optional<Number> getNumericValue(OmObservation observation) {
        SingleObservationValue singleValue = (SingleObservationValue)observation.getValue();
        Object value = singleValue.getValue().getValue();
        if (value instanceof Number) {
            return Optional.of((Number)value);
        }
        return Optional.empty();
    }

    private static Optional<String> getStringValue(OmObservation observation) {
        SingleObservationValue singleValue = (SingleObservationValue)observation.getValue();
        Object value = singleValue.getValue().getValue();
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    private static void setValidTime(OmObservation observation, DataEntity<?> dataEntity) {
        TimePeriod validTime = observation.getValidTime();
        if (validTime != null) {
            if (validTime.isSetStart()) {
                dataEntity.setValidTimeStart(validTime.getStart().toDate());
            }
            if (validTime.isSetEnd()) {
                dataEntity.setValidTimeEnd(validTime.getEnd().toDate());
            }
        }
    }

    private static void setResultTime(OmObservation observation, DataEntity<?> dataEntity) {
        TimeInstant resultTime = observation.getResultTime();
        if (resultTime != null && resultTime.isSetValue()) {
            dataEntity.setResultTime(resultTime.getValue().toDate());
        } else {
            Time phenomenonTime = observation.getPhenomenonTime();
            if (phenomenonTime instanceof TimeInstant) {
                TimeInstant instant = (TimeInstant)phenomenonTime;
                if (instant.isSetValue()) {
                    dataEntity.setResultTime(instant.getValue().toDate());
                }
            } else if (phenomenonTime instanceof TimePeriod) {
                TimePeriod period = (TimePeriod)phenomenonTime;
                if (period.isSetStart()) {
                    dataEntity.setResultTime(period.getStart().toDate());
                } else if (period.isSetEnd()) {
                    dataEntity.setResultTime(period.getEnd().toDate());
                }
            }
        }
    }

    private static void setPhenomenonTime(OmObservation observation, DataEntity<?> dataEntity) {
        Time phenomenonTime = observation.getPhenomenonTime();
        if (phenomenonTime instanceof TimeInstant) {
            TimeInstant instant = (TimeInstant)phenomenonTime;
            dataEntity.setTimestart(instant.getValue().toDate());
            dataEntity.setTimeend(instant.getValue().toDate());
        } else if (phenomenonTime instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)phenomenonTime;
            dataEntity.setTimestart(period.getStart().toDate());
            dataEntity.setTimeend(period.getEnd().toDate());
        } else {
            LOGGER.warn("No matching time found");
        }
    }

    private static void setGeometry(OmObservation observation, DataEntity<?> dataEntity) {
        Optional.ofNullable(observation.getSpatialFilteringProfileParameter()).filter(NamedValue::isSetValue).map(NamedValue::getValue).filter(Value::isSetValue).map(Value::getValue).map(JTSGeometryConverter::convert).map(GeometryEntity::new).ifPresent(arg_0 -> dataEntity.setGeometryEntity(arg_0));
    }

    private static <T, D extends DataEntity<T>> D setCommonValues(OmObservation observation, D dataEntity) {
        dataEntity.setDeleted(Boolean.valueOf(false));
        dataEntity.setChild(false);
        dataEntity.setParent(false);
        DataEntityBuilder.setPhenomenonTime(observation, dataEntity);
        DataEntityBuilder.setValidTime(observation, dataEntity);
        DataEntityBuilder.setResultTime(observation, dataEntity);
        DataEntityBuilder.setGeometry(observation, dataEntity);
        return dataEntity;
    }
}

