/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.n52.proxy.connector.constellations.DatasetConstellation;
import org.n52.proxy.connector.utils.EntityBuilder;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.dao.JTSGeometryConverter;
import org.n52.shetland.util.JTSHelper;

public class ServiceConstellation {
    private ProxyServiceEntity service;
    private final Map<String, ProcedureEntity> procedures = new HashMap<String, ProcedureEntity>();
    private final Map<String, OfferingEntity> offerings = new HashMap<String, OfferingEntity>();
    private final Map<String, CategoryEntity> categories = new HashMap<String, CategoryEntity>();
    private final Map<String, PhenomenonEntity> phenomena = new HashMap<String, PhenomenonEntity>();
    private final Map<String, FeatureEntity> features = new HashMap<String, FeatureEntity>();
    private final Collection<DatasetConstellation<?>> datasets = new HashSet();

    public ProxyServiceEntity getService() {
        return this.service;
    }

    public PhenomenonEntity putPhenomenon(PhenomenonEntity phenomenon) {
        this.phenomena.put(phenomenon.getDomainId(), phenomenon);
        return phenomenon;
    }

    public PhenomenonEntity putPhenomenon(String id, String name) {
        return this.putPhenomenon(EntityBuilder.createPhenomenon(id, name, this.service));
    }

    public ProcedureEntity putProcedure(ProcedureEntity procedure) {
        this.procedures.put(procedure.getDomainId(), procedure);
        return procedure;
    }

    public ProcedureEntity putProcedure(String id, String name, boolean insitu, boolean mobile) {
        return this.putProcedure(EntityBuilder.createProcedure(id, name, insitu, mobile, this.service));
    }

    public OfferingEntity putOffering(OfferingEntity offering) {
        this.offerings.put(offering.getDomainId(), offering);
        return offering;
    }

    public OfferingEntity putOffering(String id, String name) {
        return this.putOffering(EntityBuilder.createOffering(id, name, this.service));
    }

    public FeatureEntity putFeature(FeatureEntity feature) {
        this.features.put(feature.getDomainId(), feature);
        return feature;
    }

    public FeatureEntity putFeature(String id, String name, String description, double latitude, double longitude, int srid) {
        return this.putFeature(id, name, description, ServiceConstellation.createGeometry(srid, longitude, latitude));
    }

    public FeatureEntity putFeature(String id, String name, String description, Geometry geometry) {
        return this.putFeature(EntityBuilder.createFeature(id, name, description, this.createGeometryEntitity(geometry), this.service));
    }

    public CategoryEntity putCategory(CategoryEntity category) {
        this.categories.put(category.getDomainId(), category);
        return category;
    }

    public CategoryEntity putCategory(String id, String name) {
        return this.putCategory(EntityBuilder.createCategory(id, name, this.service));
    }

    public void setService(ProxyServiceEntity service) {
        this.service = service;
    }

    public Map<String, ProcedureEntity> getProcedures() {
        return this.procedures;
    }

    public boolean hasProcedure(String procedureId) {
        return this.procedures.containsKey(procedureId);
    }

    public Map<String, OfferingEntity> getOfferings() {
        return this.offerings;
    }

    public boolean hasOffering(String offeringId) {
        return this.offerings.containsKey(offeringId);
    }

    public Map<String, CategoryEntity> getCategories() {
        return this.categories;
    }

    public boolean hasCategories(String categoryId) {
        return this.categories.containsKey(categoryId);
    }

    public Map<String, PhenomenonEntity> getPhenomena() {
        return this.phenomena;
    }

    public boolean hasPhenomenon(String phenomenonId) {
        return this.phenomena.containsKey(phenomenonId);
    }

    public Map<String, FeatureEntity> getFeatures() {
        return this.features;
    }

    public boolean hasFeature(String featureId) {
        return this.features.containsKey(featureId);
    }

    public Collection<DatasetConstellation<?>> getDatasets() {
        return this.datasets;
    }

    public boolean add(DatasetConstellation<?> e) {
        return this.datasets.add(e);
    }

    protected GeometryEntity createGeometryEntitity(Geometry geometry) {
        com.vividsolutions.jts.geom.Geometry geom = JTSGeometryConverter.convert((Geometry)geometry);
        GeometryEntity geometryEntity = new GeometryEntity();
        geometryEntity.setGeometry(geom);
        geometryEntity.setSrid(geometry.getSRID());
        geometryEntity.setGeometryFactory(geom.getFactory());
        return geometryEntity;
    }

    protected static Geometry createGeometry(int srid, double longitude, double latitude) {
        return JTSHelper.getGeometryFactoryForSRID((int)srid).createPoint(new Coordinate(longitude, latitude));
    }
}

