/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.decode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.opengis.gml.x32.AbstractFeatureType;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.gml.x32.ReferenceType;
import net.opengis.sampling.x20.SFSamplingFeatureDocument;
import net.opengis.sampling.x20.SFSamplingFeatureType;
import net.opengis.samplingSpatial.x20.ShapeDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.svalbard.decode.AbstractGmlDecoderv321;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SamplingFeatureDecoder
extends AbstractGmlDecoderv321<XmlObject, AbstractFeature> {
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sampling/2.0", (Class[])new Class[]{SFSamplingFeatureDocument.class, SFSamplingFeatureType.class});

    public AbstractFeature decode(XmlObject element) throws DecodingException {
        return this.parseSamplingFeature(((SFSamplingFeatureDocument)element).getSFSamplingFeature());
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    private AbstractFeature parseSamplingFeature(SFSamplingFeatureType sfSamplingFeature) throws DecodingException {
        SamplingFeature sosFeat = new SamplingFeature(null, sfSamplingFeature.getId());
        this.parseAbstractFeatureType((AbstractFeatureType)sfSamplingFeature, (AbstractFeature)sosFeat);
        sosFeat.setFeatureType(this.getFeatureType(sfSamplingFeature.getType()));
        sosFeat.setSampledFeatures(this.getSampledFeatures(sfSamplingFeature.getSampledFeatureArray()));
        sosFeat.setXml(this.getXmlDescription(sfSamplingFeature));
        sosFeat.setGeometry(this.getGeometry(sfSamplingFeature));
        this.checkTypeAndGeometry(sosFeat);
        sosFeat.setGmlId(sfSamplingFeature.getId());
        return sosFeat;
    }

    private String getFeatureType(ReferenceType type) {
        if (type != null && type.getHref() != null && !type.getHref().isEmpty()) {
            return type.getHref();
        }
        return null;
    }

    private List<AbstractFeature> getSampledFeatures(FeaturePropertyType[] sampledFeatureArray) throws DecodingException {
        ArrayList sampledFeatures = Lists.newArrayList();
        for (FeaturePropertyType featurePropertyType : sampledFeatureArray) {
            sampledFeatures.addAll(this.getSampledFeatures(featurePropertyType));
        }
        return sampledFeatures;
    }

    private List<AbstractFeature> getSampledFeatures(FeaturePropertyType sampledFeature) throws DecodingException {
        ArrayList<AbstractFeature> sampledFeatures = new ArrayList<AbstractFeature>(1);
        if (sampledFeature != null && !sampledFeature.isNil()) {
            if (sampledFeature.getHref() != null && !sampledFeature.getHref().isEmpty()) {
                if (sampledFeature.getHref().startsWith("#")) {
                    sampledFeatures.add((AbstractFeature)new SamplingFeature(null, sampledFeature.getHref().replace("#", "")));
                } else {
                    SamplingFeature sampFeat = new SamplingFeature(new CodeWithAuthority(sampledFeature.getHref()));
                    if (sampledFeature.getTitle() != null && !sampledFeature.getTitle().isEmpty()) {
                        sampFeat.addName(new CodeType(sampledFeature.getTitle()));
                    }
                    sampledFeatures.add((AbstractFeature)sampFeat);
                }
            } else {
                Object decodedObject;
                AbstractFeatureType abstractFeature = null;
                if (sampledFeature.getAbstractFeature() != null) {
                    abstractFeature = sampledFeature.getAbstractFeature();
                } else if (sampledFeature.getDomNode().hasChildNodes()) {
                    try {
                        abstractFeature = XmlObject.Factory.parse((Node)XmlHelper.getNodeFromNodeList((NodeList)sampledFeature.getDomNode().getChildNodes()));
                    }
                    catch (XmlException xmle) {
                        throw new DecodingException("Error while parsing feature request!", (Throwable)xmle);
                    }
                }
                if (abstractFeature != null && (decodedObject = this.decodeXmlObject((XmlObject)abstractFeature)) instanceof AbstractFeature) {
                    sampledFeatures.add((AbstractFeature)decodedObject);
                }
                throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested sampledFeature type is not supported by this service!", new Object[0]);
            }
        }
        return sampledFeatures;
    }

    private String getXmlDescription(SFSamplingFeatureType sfSamplingFeature) {
        SFSamplingFeatureDocument featureDoc = SFSamplingFeatureDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        featureDoc.setSFSamplingFeature(sfSamplingFeature);
        return featureDoc.xmlText(this.getXmlOptions());
    }

    private void checkTypeAndGeometry(SamplingFeature sosFeat) throws DecodingException {
        String featTypeForGeometry = this.getFeatTypeForGeometry(sosFeat.getGeometry());
        if (sosFeat.getFeatureType() == null) {
            sosFeat.setFeatureType(featTypeForGeometry);
        } else if (!featTypeForGeometry.equals(sosFeat.getFeatureType())) {
            throw new DecodingException("The requested observation is invalid! The featureOfInterest type does not comply with the defined type (%s)!", sosFeat.getFeatureType(), new Object[0]);
        }
    }

    private String getFeatTypeForGeometry(Geometry geometry) {
        if (geometry instanceof Point) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint";
        }
        if (geometry instanceof LineString) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve";
        }
        if (geometry instanceof Polygon) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface";
        }
        return "http://www.opengis.net/def/nil/OGC/0/unknown";
    }

    private Geometry getGeometry(SFSamplingFeatureType sfSamplingFeature) throws DecodingException {
        XmlObject[] shapes = sfSamplingFeature.selectChildren("http://www.opengis.net/samplingSpatial/2.0", "shape");
        if (shapes.length == 1) {
            try {
                ShapeDocument shapeDoc = (ShapeDocument)XmlObject.Factory.parse((Node)shapes[0].getDomNode());
                Object decodedObject = this.decodeXmlElement((XmlObject)shapeDoc.getShape().getAbstractGeometry());
                if (decodedObject instanceof Geometry) {
                    return (Geometry)decodedObject;
                }
            }
            catch (XmlException ex) {
                throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested geometry type of featureOfInterest is not supported by this service!", new Object[0]);
            }
        }
        throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested geometry type of featureOfInterest is of wrong length!", new Object[0]);
    }
}

