/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.HttpResponse;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.QueryBuilder;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.connector.ConnectorRequestFailedException;
import org.n52.proxy.connector.constellations.QuantityDatasetConstellation;
import org.n52.proxy.connector.utils.DataEntityBuilder;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.series.db.beans.CountDatasetEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.beans.TextDatasetEntity;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.OwsOperation;
import org.n52.shetland.ogc.ows.OwsOperationsMetadata;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityConstants;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.ogc.sos.request.DescribeSensorRequest;
import org.n52.shetland.ogc.sos.request.GetFeatureOfInterestRequest;
import org.n52.shetland.ogc.sos.request.GetObservationRequest;
import org.n52.shetland.ogc.sos.response.DescribeSensorResponse;
import org.n52.shetland.ogc.sos.response.GetFeatureOfInterestResponse;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NoDecoderForKeyException;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncoderRepository;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSosConnector
extends AbstractConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSosConnector.class);
    private static final String COULD_NOT_RETRIEVE_RESPONSE = "Could not retrieve response";
    protected int counter;
    private DecoderRepository decoderRepository;
    private EncoderRepository encoderRepository;

    public DecoderRepository getDecoderRepository() {
        return this.decoderRepository;
    }

    @Autowired
    public void setDecoderRepository(DecoderRepository decoderRepository) {
        this.decoderRepository = decoderRepository;
    }

    public EncoderRepository getEncoderRepository() {
        return this.encoderRepository;
    }

    @Autowired
    public void setEncoderRepository(EncoderRepository encoderRepository) {
        this.encoderRepository = encoderRepository;
    }

    public boolean matches(DataSourceConfiguration config, GetCapabilitiesResponse capabilities) {
        if (config.getConnector() != null) {
            return this.getClass().getSimpleName().equals(config.getConnector()) || this.getClass().getName().equals(config.getConnector());
        }
        return this.canHandle(config, capabilities);
    }

    protected Object getSosResponseFor(String uri) {
        try {
            return this.decodeResponse(this.sendGetRequest(uri));
        }
        catch (IOException ex) {
            LOGGER.error(COULD_NOT_RETRIEVE_RESPONSE, (Throwable)ex);
            throw new ConnectorRequestFailedException(ex);
        }
    }

    protected Object getSosResponseFor(URL uri) {
        return this.getSosResponseFor(uri.toString());
    }

    protected Object getSosResponseFor(OwsServiceRequest request, String namespace, String serviceUrl) {
        ++this.counter;
        try {
            EncoderKey encoderKey = CodingHelper.getEncoderKey((String)namespace, (Object)request);
            Encoder encoder = this.getEncoderRepository().getEncoder(encoderKey, new EncoderKey[0]);
            if (encoder == null) {
                throw new NoEncoderForKeyException((Object)encoderKey);
            }
            XmlObject xmlRequest = (XmlObject)encoder.encode((Object)request);
            return this.decodeResponse(this.sendPostRequest(xmlRequest, serviceUrl));
        }
        catch (IOException ex) {
            LOGGER.error(COULD_NOT_RETRIEVE_RESPONSE, (Throwable)ex);
            throw new ConnectorRequestFailedException(ex);
        }
        catch (EncodingException ex) {
            LOGGER.error("Could not encode request : " + request, (Throwable)ex);
            throw new ConnectorRequestFailedException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object decodeResponse(HttpResponse response) {
        try (InputStream content = response.getEntity().getContent();){
            XmlObject xmlResponse = XmlObject.Factory.parse((InputStream)content);
            DecoderKey decoderKey = CodingHelper.getDecoderKey((XmlObject)xmlResponse);
            Decoder decoder = this.getDecoderRepository().getDecoder(decoderKey, new DecoderKey[0]);
            if (decoder == null) {
                throw new NoDecoderForKeyException(decoderKey);
            }
            Object decode = decoder.decode((Object)xmlResponse);
            if (decode instanceof OwsExceptionReport) {
                throw new ConnectorRequestFailedException((Throwable)((OwsExceptionReport)decode));
            }
            Object object = decode;
            return object;
        }
        catch (IOException ex) {
            LOGGER.error(COULD_NOT_RETRIEVE_RESPONSE, (Throwable)ex);
            throw new ConnectorRequestFailedException(ex);
        }
        catch (XmlException ex) {
            LOGGER.error("Could not parse response XML", (Throwable)ex);
            throw new ConnectorRequestFailedException(ex);
        }
        catch (DecodingException ex) {
            LOGGER.error("Could not decode response", (Throwable)ex);
            throw new ConnectorRequestFailedException(ex);
        }
    }

    protected abstract boolean canHandle(DataSourceConfiguration var1, GetCapabilitiesResponse var2);

    public abstract ServiceConstellation getConstellation(DataSourceConfiguration var1, GetCapabilitiesResponse var2);

    protected DataEntity<?> createDataEntity(OmObservation observation, DatasetEntity seriesEntity) {
        if (seriesEntity instanceof QuantityDatasetEntity) {
            return DataEntityBuilder.createQuantityDataEntity(observation);
        }
        if (seriesEntity instanceof CountDatasetEntity) {
            return DataEntityBuilder.createCountDataEntity(observation);
        }
        if (seriesEntity instanceof TextDatasetEntity) {
            return DataEntityBuilder.createTextDataEntity(observation);
        }
        LOGGER.error("No supported datasetEntity for ", (Object)seriesEntity);
        return null;
    }

    protected GetFeatureOfInterestResponse getFeatureOfInterestByProcedure(String procedureId, String serviceUri) {
        return this.getFeatureOfInterest(null, procedureId, null, serviceUri);
    }

    protected GetFeatureOfInterestResponse getFeatureOfInterestById(String featureId, String serviceUri) {
        return this.getFeatureOfInterest(featureId, null, null, serviceUri);
    }

    protected GetFeatureOfInterestResponse getFeatureOfInterest(String featureId, String procedureId, String obsProp, String url) {
        GetFeatureOfInterestRequest request = new GetFeatureOfInterestRequest("SOS", "2.0.0");
        Optional.ofNullable(featureId).map(xva$0 -> Arrays.asList(xva$0)).ifPresent(arg_0 -> ((GetFeatureOfInterestRequest)request).setFeatureIdentifiers(arg_0));
        Optional.ofNullable(procedureId).map(xva$0 -> Arrays.asList(xva$0)).ifPresent(arg_0 -> ((GetFeatureOfInterestRequest)request).setProcedures(arg_0));
        Optional.ofNullable(obsProp).map(xva$0 -> Arrays.asList(xva$0)).ifPresent(arg_0 -> ((GetFeatureOfInterestRequest)request).setObservedProperties(arg_0));
        return (GetFeatureOfInterestResponse)this.getSosResponseFor((OwsServiceRequest)request, "http://www.opengis.net/sos/2.0", url);
    }

    protected DescribeSensorResponse describeSensor(String procedureId, String url, String format) {
        DescribeSensorRequest request = new DescribeSensorRequest("SOS", "2.0.0");
        request.setProcedure(procedureId);
        request.setProcedureDescriptionFormat(format);
        return (DescribeSensorResponse)this.getSosResponseFor((OwsServiceRequest)request, "http://www.opengis.net/swes/2.0", url);
    }

    protected boolean supportsGDA(OwsCapabilities owsCaps) {
        return owsCaps.getOperationsMetadata().map(OwsOperationsMetadata::getOperations).map(Collection::stream).orElseGet(Stream::empty).map(OwsOperation::getName).anyMatch(name -> name.equals("GetDataAvailability"));
    }

    protected GetDataAvailabilityResponse getDataAvailabilityByProcedure(String procedureId, String serviceURL) {
        return this.getDataAvailability(procedureId, null, null, null, serviceURL);
    }

    protected GetDataAvailabilityResponse getDataAvailability(DatasetEntity seriesEntity) {
        return this.getDataAvailability(seriesEntity.getProcedure().getDomainId(), seriesEntity.getOffering().getDomainId(), seriesEntity.getPhenomenon().getDomainId(), seriesEntity.getFeature().getDomainId(), seriesEntity.getService().getUrl());
    }

    protected GetDataAvailabilityResponse getDataAvailability(QuantityDatasetConstellation dataset, String serviceURL) {
        return this.getDataAvailability(dataset.getProcedure(), dataset.getOffering(), dataset.getPhenomenon(), dataset.getFeature(), serviceURL);
    }

    protected GetDataAvailabilityResponse getDataAvailability(String procedure, String offering, String phenomenon, String feature, String url) {
        try {
            QueryBuilder builder = new QueryBuilder(url);
            builder.add((Enum)OWSConstants.RequestParams.service, new Object[]{"SOS"});
            builder.add((Enum)OWSConstants.RequestParams.version, new Object[]{"2.0.0"});
            builder.add((Enum)OWSConstants.RequestParams.request, new Object[]{"GetDataAvailability"});
            builder.add((Enum)GetDataAvailabilityConstants.GetDataAvailabilityParams.procedure, new Object[]{procedure});
            builder.add((Enum)GetDataAvailabilityConstants.GetDataAvailabilityParams.offering, new Object[]{offering});
            builder.add((Enum)GetDataAvailabilityConstants.GetDataAvailabilityParams.observedProperty, new Object[]{phenomenon});
            builder.add((Enum)GetDataAvailabilityConstants.GetDataAvailabilityParams.featureOfInterest, new Object[]{feature});
            return (GetDataAvailabilityResponse)this.getSosResponseFor(builder.build());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected GetObservationResponse getObservation(DatasetEntity seriesEntity, TemporalFilter temporalFilter) {
        return this.getObservation(seriesEntity, temporalFilter, null, null);
    }

    protected GetObservationResponse getObservation(DatasetEntity seriesEntity, TemporalFilter temporalFilter, SpatialFilter spatialFilter) {
        return this.getObservation(seriesEntity, temporalFilter, spatialFilter, null);
    }

    protected GetObservationResponse getObservation(DatasetEntity seriesEntity, TemporalFilter temporalFilter, String responseFormat) {
        return this.getObservation(seriesEntity, temporalFilter, null, responseFormat);
    }

    protected GetObservationResponse getObservation(DatasetEntity seriesEntity, TemporalFilter temporalFilter, SpatialFilter spatialFilter, String responseFormat) {
        return this.getObservation(seriesEntity, Optional.ofNullable(temporalFilter).map(xva$0 -> Arrays.asList(xva$0)).orElseGet(Collections::emptyList), spatialFilter, responseFormat);
    }

    protected GetObservationResponse getObservation(DatasetEntity seriesEntity, List<TemporalFilter> temporalFilter, SpatialFilter spatialFilter, String responseFormat) {
        GetObservationRequest request = new GetObservationRequest("SOS", "2.0.0");
        request.addProcedure(seriesEntity.getProcedure().getDomainId());
        request.addOffering(seriesEntity.getOffering().getDomainId());
        request.addObservedProperty(seriesEntity.getPhenomenon().getDomainId());
        request.addFeatureIdentifier(seriesEntity.getFeature().getDomainId());
        Optional.ofNullable(temporalFilter).ifPresent(arg_0 -> ((GetObservationRequest)request).setTemporalFilters(arg_0));
        Optional.ofNullable(spatialFilter).ifPresent(arg_0 -> ((GetObservationRequest)request).setSpatialFilter(arg_0));
        Optional.ofNullable(responseFormat).ifPresent(arg_0 -> ((GetObservationRequest)request).setResponseFormat(arg_0));
        return (GetObservationResponse)this.getSosResponseFor((OwsServiceRequest)request, "http://www.opengis.net/sos/2.0", seriesEntity.getService().getUrl());
    }
}

