/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.dao;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.dao.InsertDao;
import org.n52.proxy.db.dao.ProxyDbQuery;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.dao.DatasetDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDatasetDao<T extends DatasetEntity>
extends DatasetDao<T>
implements InsertDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyDatasetDao.class);

    public ProxyDatasetDao(Session session) {
        super(session);
    }

    public ProxyDatasetDao(Session session, Class<T> clazz) {
        super(session, clazz);
    }

    @Override
    public T getOrInsertInstance(T dataset) {
        T instance;
        if (dataset.getUnit() != null) {
            dataset.setUnit(this.getOrInsertUnit(dataset.getUnit()));
        }
        if ((instance = this.getInstance(dataset)) == null) {
            this.session.save(dataset);
            LOGGER.info("Save dataset: " + dataset);
            this.session.flush();
            this.session.refresh(dataset);
            return dataset;
        }
        return instance;
    }

    public UnitEntity getOrInsertUnit(UnitEntity unit) {
        UnitEntity instance = this.getUnit(unit);
        if (instance == null) {
            this.session.save((Object)unit);
            this.session.flush();
            return unit;
        }
        return instance;
    }

    public Set<Long> getIdsForService(ProxyServiceEntity service) {
        return this.getDatasetsForService(service).stream().map(DescribableEntity::getPkid).collect(Collectors.toSet());
    }

    public void removeDatasets(Set<Long> datasetIds) {
        datasetIds.forEach(id -> this.session.delete(this.session.get(DatasetEntity.class, (Serializable)id)));
        this.session.flush();
    }

    public void removeAllOfService(ProxyServiceEntity service) {
        this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add((Criterion)Restrictions.eq((String)"service", (Object)((Object)service))).list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
        this.session.createCriteria(UnitEntity.class).add((Criterion)Restrictions.eq((String)"service", (Object)((Object)service))).list().forEach(arg_0 -> ((Session)this.session).delete(arg_0));
        this.session.flush();
    }

    private UnitEntity getUnit(UnitEntity unit) {
        return (UnitEntity)this.session.createCriteria(UnitEntity.class).add((Criterion)Restrictions.eq((String)"name", (Object)unit.getName())).add((Criterion)Restrictions.eq((String)"service", (Object)unit.getService())).uniqueResult();
    }

    private T getInstance(T dataset) {
        return (T)((DatasetEntity)this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add((Criterion)Restrictions.eq((String)"valueType", (Object)dataset.getValueType())).add((Criterion)Restrictions.eq((String)"category", (Object)dataset.getCategory())).add((Criterion)Restrictions.eq((String)"feature", (Object)dataset.getFeature())).add((Criterion)Restrictions.eq((String)"procedure", (Object)dataset.getProcedure())).add((Criterion)Restrictions.eq((String)"phenomenon", (Object)dataset.getPhenomenon())).add((Criterion)Restrictions.eq((String)"offering", (Object)dataset.getOffering())).add((Criterion)Restrictions.eq((String)"service", (Object)dataset.getService())).uniqueResult());
    }

    private List<T> getDatasetsForService(ServiceEntity service) {
        return this.getDefaultCriteria(ProxyDbQuery.createDefaults()).add((Criterion)Restrictions.eq((String)"service", (Object)service)).list();
    }
}

