/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.List;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.config.DataSourcesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationReader.class);
    private static final String CONFIG_FILE = "/config-data-sources.json";
    private final DataSourcesConfiguration intervalConfig = this.readConfig();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSourcesConfiguration readConfig() {
        try (InputStream config = this.getClass().getResourceAsStream(CONFIG_FILE);){
            ObjectMapper om = new ObjectMapper();
            DataSourcesConfiguration dataSourcesConfiguration = (DataSourcesConfiguration)om.readValue(config, DataSourcesConfiguration.class);
            return dataSourcesConfiguration;
        }
        catch (Exception e) {
            LOGGER.error("Could not load {). Using empty config.", (Object)CONFIG_FILE, (Object)e);
            return new DataSourcesConfiguration();
        }
    }

    public List<DataSourceConfiguration> getDataSource() {
        return this.intervalConfig.getDataSources();
    }
}

