/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.n52.janmayen.function.Functions;
import org.n52.janmayen.function.Predicates;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.connector.SOS2Connector;
import org.n52.proxy.connector.constellations.QuantityDatasetConstellation;
import org.n52.proxy.connector.utils.EntityBuilder;
import org.n52.proxy.connector.utils.ProxyException;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.ogc.sos.response.GetFeatureOfInterestResponse;
import org.n52.shetland.ogc.sos.ro.RelatedOfferings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedOfferingsSOSConnector
extends SOS2Connector {
    private static final Logger LOGGER = LoggerFactory.getLogger(NestedOfferingsSOSConnector.class);

    @Override
    protected boolean canHandle(DataSourceConfiguration config, GetCapabilitiesResponse capabilities) {
        return false;
    }

    @Override
    protected void doForOffering(SosObservationOffering obsOff, ServiceConstellation serviceConstellation, DataSourceConfiguration config) {
        obsOff.getExtension("relatedOfferings").filter(Predicates.instanceOf(RelatedOfferings.class)).ifPresent(e -> this.addNestedOfferings((RelatedOfferings)e, serviceConstellation, config.getUrl()));
    }

    @Override
    public Optional<DataEntity<?>> getFirstObservation(DatasetEntity entity) {
        return Optional.empty();
    }

    @Override
    public Optional<DataEntity<?>> getLastObservation(DatasetEntity entity) {
        return Optional.empty();
    }

    @Override
    public List<DataEntity<?>> getObservations(DatasetEntity seriesEntity, DbQuery query) {
        List<DataEntity<?>> data = this.getObservation(seriesEntity, this.createTimeFilter(query)).getObservationCollection().toStream().map(Functions.currySecond(this::createDataEntity, (Object)seriesEntity)).collect(Collectors.toList());
        LOGGER.info("Found {} Entries", (Object)data.size());
        return data;
    }

    @Override
    public UnitEntity getUom(DatasetEntity seriesEntity) {
        return EntityBuilder.createUnit("unit", null, (ProxyServiceEntity)seriesEntity.getService());
    }

    private void addNestedOfferings(RelatedOfferings relatedOfferings, ServiceConstellation serviceConstellation, String serviceUri) {
        relatedOfferings.getValue().forEach(context -> {
            try {
                ReferenceType relatedOffering = context.getRelatedOffering();
                LOGGER.info("Fetch nested offerings for {}", (Object)relatedOffering.getTitle());
                if (relatedOffering.getTitle().equalsIgnoreCase("http://ressource.brgm-rec.fr/obs/RawGeologicLogs/BSS000AAEU")) {
                    GetDataAvailabilityResponse response = this.getDataAvailabilityForOffering(relatedOffering.getHref());
                    response.getDataAvailabilities().forEach(dataAvail -> {
                        GetFeatureOfInterestResponse foiResponse;
                        AbstractFeature abstractFeature;
                        String procedureId = this.addProcedure((GetDataAvailabilityResponse.DataAvailability)dataAvail, true, false, serviceConstellation);
                        String phenomenonId = this.addPhenomenon((GetDataAvailabilityResponse.DataAvailability)dataAvail, serviceConstellation);
                        String categoryId = this.addCategory((GetDataAvailabilityResponse.DataAvailability)dataAvail, serviceConstellation);
                        String offeringId = this.addOffering(dataAvail.getOffering(), serviceConstellation);
                        String featureId = dataAvail.getFeatureOfInterest().getHref();
                        if (!serviceConstellation.hasFeature(featureId) && (abstractFeature = (foiResponse = this.getFeatureOfInterestById(featureId, serviceUri)).getAbstractFeature()) instanceof SamplingFeature) {
                            this.addFeature((SamplingFeature)abstractFeature, serviceConstellation);
                        }
                        serviceConstellation.add(new QuantityDatasetConstellation(procedureId, offeringId, categoryId, phenomenonId, featureId));
                    });
                }
            }
            catch (ProxyException ex) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)((Object)ex));
            }
        });
    }

    private GetDataAvailabilityResponse getDataAvailabilityForOffering(String uri) throws ProxyException {
        OwsServiceResponse response = (OwsServiceResponse)this.getSosResponseFor(uri);
        if (response instanceof GetDataAvailabilityResponse) {
            return (GetDataAvailabilityResponse)response;
        }
        throw new ProxyException("Wrong response - GetDataAvailabilityResponse was expected", response);
    }
}

