/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector.constellations;

import java.util.Optional;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.ServiceEntity;

public abstract class DatasetConstellation<T extends DatasetEntity> {
    private final String procedure;
    private final String offering;
    private final String category;
    private final String phenomenon;
    private final String feature;
    private DataEntity<?> first;
    private DataEntity<?> latest;
    private String domainId;

    public DatasetConstellation(String procedure, String offering, String category, String phenomenon, String feature) {
        this.procedure = procedure;
        this.offering = offering;
        this.category = category;
        this.phenomenon = phenomenon;
        this.feature = feature;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public String getOffering() {
        return this.offering;
    }

    public String getCategory() {
        return this.category;
    }

    public String getPhenomenon() {
        return this.phenomenon;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String toString() {
        return "DatasetConstellation{procedure=" + this.procedure + ", offering=" + this.offering + ", category=" + this.category + ", phenomenon=" + this.phenomenon + ", feature=" + this.feature + '}';
    }

    public final T createDatasetEntity(ProcedureEntity procedure, CategoryEntity category, FeatureEntity feature, OfferingEntity offering, PhenomenonEntity phenomenon, ProxyServiceEntity service) {
        T datasetEntity = this.createDatasetEntity(service);
        datasetEntity.setDomainId(this.getDomainId());
        datasetEntity.setProcedure(procedure);
        datasetEntity.setCategory(category);
        datasetEntity.setFeature(feature);
        datasetEntity.setPhenomenon(phenomenon);
        datasetEntity.setOffering(offering);
        datasetEntity.setPublished(Boolean.valueOf(true));
        datasetEntity.setDeleted(Boolean.valueOf(false));
        datasetEntity.setService((ServiceEntity)service);
        this.getLatest().map(DataEntity::getTimestart).ifPresent(arg_0 -> datasetEntity.setLastValueAt(arg_0));
        this.getFirst().map(DataEntity::getTimestart).ifPresent(arg_0 -> datasetEntity.setFirstValueAt(arg_0));
        return datasetEntity;
    }

    protected abstract T createDatasetEntity(ProxyServiceEntity var1);

    public Optional<DataEntity<?>> getFirst() {
        return Optional.ofNullable(this.first);
    }

    public void setFirst(DataEntity<?> first) {
        this.first = first;
    }

    public Optional<DataEntity<?>> getLatest() {
        return Optional.ofNullable(this.latest);
    }

    public void setLatest(DataEntity<?> latest) {
        this.latest = latest;
    }
}

