/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.connector.utils;

import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.UnitEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityBuilder.class);

    private EntityBuilder() {
    }

    public static ProxyServiceEntity createService(String name, String description, String connector, String url, String version) {
        ProxyServiceEntity service = new ProxyServiceEntity();
        service.setName(name);
        service.setDescription(description);
        service.setVersion(version);
        service.setType("SOS");
        service.setUrl(url);
        service.setConnector(connector);
        return service;
    }

    public static ProcedureEntity createProcedure(String domainId, String name, boolean insitu, boolean mobile, ProxyServiceEntity service) {
        ProcedureEntity procedure = new ProcedureEntity();
        procedure.setName(name);
        procedure.setDomainId(domainId);
        procedure.setInsitu(insitu);
        procedure.setMobile(mobile);
        procedure.setService((ServiceEntity)service);
        return procedure;
    }

    public static OfferingEntity createOffering(String domainId, String name, ProxyServiceEntity service) {
        OfferingEntity offering = new OfferingEntity();
        offering.setDomainId(domainId);
        offering.setName(name);
        offering.setService((ServiceEntity)service);
        return offering;
    }

    public static CategoryEntity createCategory(String domainId, String name, ProxyServiceEntity service) {
        CategoryEntity category = new CategoryEntity();
        category.setName(name);
        category.setDomainId(domainId);
        category.setService((ServiceEntity)service);
        return category;
    }

    public static FeatureEntity createFeature(String domainId, String name, String description, GeometryEntity geometry, ProxyServiceEntity service) {
        FeatureEntity feature = new FeatureEntity();
        feature.setName(name);
        feature.setDescription(description);
        feature.setDomainId(domainId);
        feature.setGeometryEntity(geometry);
        feature.setService((ServiceEntity)service);
        return feature;
    }

    public static PhenomenonEntity createPhenomenon(String domainId, String name, ProxyServiceEntity service) {
        PhenomenonEntity phenomenon = new PhenomenonEntity();
        phenomenon.setName(name);
        phenomenon.setDomainId(domainId);
        phenomenon.setService((ServiceEntity)service);
        return phenomenon;
    }

    public static UnitEntity createUnit(String unit, String unitDescription, ProxyServiceEntity service) {
        UnitEntity entity = new UnitEntity();
        entity.setName(unit);
        entity.setDescription(unitDescription);
        entity.setService((ServiceEntity)service);
        return entity;
    }
}

