/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.db.da;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.profile.ProfileValue;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.ProfileDatasetEntity;
import org.n52.series.db.beans.QuantityProfileDatasetEntity;
import org.n52.series.db.da.QuantityProfileDataRepository;
import org.n52.series.db.dao.DbQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ProxyQuantityProfileDataRepository
extends QuantityProfileDataRepository {
    private Map<String, AbstractConnector> connectorMap;

    @Autowired
    public void setConnectors(List<AbstractConnector> connectors) {
        this.connectorMap = connectors.stream().collect(Collectors.toMap(AbstractConnector::getConnectorName, Function.identity()));
    }

    private AbstractConnector getConnector(ProfileDatasetEntity profileDatasetEntity) {
        String connectorName = ((ProxyServiceEntity)profileDatasetEntity.getService()).getConnector();
        return this.connectorMap.get(connectorName);
    }

    public ProfileValue<BigDecimal> getFirstValue(QuantityProfileDatasetEntity profileDatasetEntity, Session session, DbQuery query) {
        DataEntity firstObs = this.getConnector((ProfileDatasetEntity)profileDatasetEntity).getFirstObservation((DatasetEntity)profileDatasetEntity).orElse(null);
        if (firstObs == null) {
            return null;
        }
        return this.assembleDataValue((ProfileDataEntity)firstObs, profileDatasetEntity, query);
    }

    public ProfileValue<BigDecimal> getLastValue(QuantityProfileDatasetEntity profileDatasetEntity, Session session, DbQuery query) {
        DataEntity lastObs = this.getConnector((ProfileDatasetEntity)profileDatasetEntity).getLastObservation((DatasetEntity)profileDatasetEntity).orElse(null);
        if (lastObs == null) {
            return null;
        }
        return this.assembleDataValue((ProfileDataEntity)lastObs, profileDatasetEntity, query);
    }

    protected Data<ProfileValue<BigDecimal>> assembleData(QuantityProfileDatasetEntity profileDatasetEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        this.getConnector((ProfileDatasetEntity)profileDatasetEntity).getObservations((DatasetEntity)profileDatasetEntity, query).stream().map(entry -> this.assembleDataValue((ProfileDataEntity)entry, profileDatasetEntity, query)).forEach(entry -> result.addNewValue((AbstractValue)entry));
        return result;
    }
}

