/*
 * Decompiled with CFR 0.152.
 */
package org.n52.proxy.harvest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.io.task.ScheduledJob;
import org.n52.proxy.config.DataSourceConfiguration;
import org.n52.proxy.config.DataSourceJobConfiguration;
import org.n52.proxy.connector.AbstractConnector;
import org.n52.proxy.connector.AbstractSosConnector;
import org.n52.proxy.connector.ConnectorRequestFailedException;
import org.n52.proxy.connector.SensorThingsConnector;
import org.n52.proxy.connector.utils.ServiceConstellation;
import org.n52.proxy.db.beans.ProxyServiceEntity;
import org.n52.proxy.db.da.InsertRepository;
import org.n52.proxy.web.SimpleHttpClient;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DataSourceHarvesterJob
extends ScheduledJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceHarvesterJob.class);
    private static final String JOB_CONFIG = "config";
    private DataSourceConfiguration config;
    @Autowired
    private InsertRepository insertRepository;
    @Autowired
    private DecoderRepository decoderRepository;
    @Autowired
    private Set<AbstractConnector> connectors;

    public DataSourceConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(DataSourceConfiguration config) {
        this.config = config;
    }

    public JobDetail createJobDetails() {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put(JOB_CONFIG, (Object)this.config);
        return JobBuilder.newJob(DataSourceHarvesterJob.class).withIdentity(this.getJobName()).usingJobData(dataMap).build();
    }

    private DataSourceConfiguration recreateConfig(JobDataMap jobDataMap) {
        return (DataSourceConfiguration)jobDataMap.get((Object)JOB_CONFIG);
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobKey key = context.getJobDetail().getKey();
        LOGGER.info("{} execution starts.", (Object)key);
        DataSourceConfiguration dataSource = this.recreateConfig(context.getJobDetail().getJobDataMap());
        try {
            ServiceConstellation constellation = this.determineConstellation(dataSource);
            if (constellation == null) {
                LOGGER.warn("No connector found for {}", (Object)dataSource);
            } else {
                this.saveConstellation(constellation);
            }
            LOGGER.info("{} execution ends.", (Object)key);
        }
        catch (IOException | ConnectorRequestFailedException | DecodingException ex) {
            throw new JobExecutionException(ex);
        }
    }

    private ServiceConstellation determineConstellation(DataSourceConfiguration dataSource) throws IOException, DecodingException {
        if (dataSource.getType() == null) {
            return null;
        }
        if (dataSource.getType().equals("SOS")) {
            GetCapabilitiesResponse capabilities = this.getCapabilities(dataSource.getUrl());
            return this.determineSOSConstellation(dataSource, capabilities);
        }
        if (dataSource.getType().equals("SensorThings")) {
            return this.determineSensorThingsConstellation(dataSource);
        }
        return null;
    }

    private ServiceConstellation determineSOSConstellation(DataSourceConfiguration dataSource, GetCapabilitiesResponse capabilities) {
        return this.connectors.stream().filter(connector -> connector instanceof AbstractSosConnector).map(connector -> (AbstractSosConnector)connector).filter(connector -> connector.matches(dataSource, capabilities)).map(connector -> connector.getConstellation(dataSource, capabilities)).findFirst().orElse(null);
    }

    private ServiceConstellation determineSensorThingsConstellation(DataSourceConfiguration dataSource) {
        return this.connectors.stream().filter(connector -> connector instanceof SensorThingsConnector).map(connector -> (SensorThingsConnector)connector).map(connector -> connector.getConstellation(dataSource)).findFirst().orElse(null);
    }

    public void init(DataSourceConfiguration initConfig) {
        this.setConfig(initConfig);
        this.setJobName(initConfig.getItemName());
        if (initConfig.getJob() != null) {
            DataSourceJobConfiguration job = initConfig.getJob();
            this.setEnabled(job.isEnabled());
            this.setCronExpression(job.getCronExpression());
            this.setTriggerAtStartup(job.isTriggerAtStartup());
        }
    }

    private void saveConstellation(ServiceConstellation constellation) {
        ProxyServiceEntity service = this.insertRepository.insertService(constellation.getService());
        Set<Long> datasetIds = this.insertRepository.getIdsForService(service);
        constellation.getDatasets().forEach(dataset -> {
            ProcedureEntity procedure = constellation.getProcedures().get(dataset.getProcedure());
            CategoryEntity category = constellation.getCategories().get(dataset.getCategory());
            FeatureEntity feature = constellation.getFeatures().get(dataset.getFeature());
            OfferingEntity offering = constellation.getOfferings().get(dataset.getOffering());
            PhenomenonEntity phenomenon = constellation.getPhenomena().get(dataset.getPhenomenon());
            List<DescribableEntity> entities = Arrays.asList(procedure, category, feature, offering, phenomenon);
            if (entities.stream().allMatch(Objects::nonNull)) {
                entities.stream().forEach(x -> x.setService((ServiceEntity)service));
                DatasetEntity ds = this.insertRepository.insertDataset((DatasetEntity)dataset.createDatasetEntity(procedure, category, feature, offering, phenomenon, service));
                if (ds != null) {
                    datasetIds.remove(ds.getPkid());
                    dataset.getFirst().ifPresent(data -> this.insertRepository.insertData(ds, (DataEntity<?>)data));
                    dataset.getLatest().ifPresent(data -> this.insertRepository.insertData(ds, (DataEntity<?>)data));
                    LOGGER.info("Added dataset: {}", dataset);
                } else {
                    LOGGER.warn("Can't save dataset: {}", dataset);
                }
            } else {
                LOGGER.warn("Can't add dataset: {}", dataset);
            }
        });
        this.insertRepository.cleanUp(service, datasetIds);
    }

    private GetCapabilitiesResponse getCapabilities(String serviceUrl) throws IOException, DecodingException {
        try {
            SimpleHttpClient simpleHttpClient = new SimpleHttpClient();
            String url = serviceUrl;
            url = url.contains("?") ? url + "&" : url + "?";
            HttpResponse response = simpleHttpClient.executeGet(url + "service=SOS&request=GetCapabilities");
            XmlObject xmlResponse = XmlObject.Factory.parse((InputStream)response.getEntity().getContent());
            return (GetCapabilitiesResponse)this.decoderRepository.getDecoder(CodingHelper.getDecoderKey((XmlObject)xmlResponse), new DecoderKey[0]).decode((Object)xmlResponse);
        }
        catch (XmlException ex) {
            throw new DecodingException((Throwable)ex);
        }
    }
}

