/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.n52.web.ctrl.UrlHelper;

public class UrlHelperTest {
    @Test
    public void when_constructBackwardsCompatibleUrl_then_relativeLink() {
        String actual = new UrlHelper().constructHref(null, "/v1/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"./procedures"));
    }

    @Test
    public void when_constructUrlWithNonTrailingSlashBaseUrl_then_fullLink() {
        String actual = new UrlHelper().constructHref("http://localhost:8080/foo/bar/v1", "/v1/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"http://localhost:8080/foo/bar/v1/procedures"));
    }

    @Test
    public void when_constructUrlFromVersionLessBaseUrl_then_fullLink() {
        String actual = new UrlHelper().constructHref("http://localhost:8080/foo/bar/", "/v1/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"http://localhost:8080/foo/bar/v1/procedures"));
    }

    @Test
    public void when_constructUrlFromBaseUrl_then_fullLink() {
        String actual = new UrlHelper().constructHref("http://localhost:8080/foo/bar/v1/", "/v1/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"http://localhost:8080/foo/bar/v1/procedures"));
    }

    @Test
    public void when_constructUrlFromDeeperBaseUrl_then_fullLink() {
        String actual = new UrlHelper().constructHref("http://localhost:8080/foo/bar/v1/somewhere", "/v1/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"http://localhost:8080/foo/bar/v1/procedures"));
    }
}

