/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.n52.io.DatasetFactoryException;
import org.n52.io.DefaultIoFactory;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoFactory;
import org.n52.io.IoHandlerException;
import org.n52.io.IoStyleContext;
import org.n52.io.PrerenderingJobConfig;
import org.n52.io.measurement.img.ChartDimension;
import org.n52.io.request.IoParameters;
import org.n52.io.request.QueryParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.TimeseriesMetadataOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.measurement.MeasurementData;
import org.n52.io.response.dataset.measurement.MeasurementValue;
import org.n52.io.task.ScheduledJob;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.common.Stopwatch;
import org.n52.web.exception.ResourceNotFoundException;
import org.quartz.InterruptableJob;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.ServletConfigAware;

public class PreRenderingJob
extends ScheduledJob
implements InterruptableJob,
ServletConfigAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreRenderingJob.class);
    private static final int WIDTH_DEFAULT = 800;
    private static final int HEIGHT_DEFAULT = 500;
    private static final String LANGUAGE_DEFAULT = "en";
    private static final boolean GRID_DEFAULT = true;
    private static final boolean LEGEND_DEFAULT = false;
    private static final boolean GENERALIZE_DEFAULT = false;
    private static final String JOB_DATA_CONFIG_FILE = "configFile";
    private static final String JOB_DATA_WEBAPP_FOLDER = "webappFolder";
    private static final String IMAGE_EXTENSION = "png";
    @Autowired
    @Qualifier(value="timeseriesService")
    private ParameterService<TimeseriesMetadataOutput> timeseriesMetadataService;
    @Autowired
    @Qualifier(value="timeseriesService")
    private DataService<MeasurementData> timeseriesDataService;
    private PrerenderingJobConfig taskConfigPrerendering;
    private String webappFolder;
    private String configFile;
    private boolean interrupted;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrerenderingJobConfig readJobConfig(String file) {
        try (InputStream taskConfig = ((Object)((Object)this)).getClass().getResourceAsStream(file);){
            ObjectMapper om = new ObjectMapper();
            PrerenderingJobConfig prerenderingJobConfig = (PrerenderingJobConfig)om.readValue(taskConfig, PrerenderingJobConfig.class);
            return prerenderingJobConfig;
        }
        catch (IOException e) {
            LOGGER.error("Could not load {}. Using empty config.", (Object)file, (Object)e);
            return new PrerenderingJobConfig();
        }
    }

    public JobDetail createJobDetails() {
        return JobBuilder.newJob(PreRenderingJob.class).withIdentity(this.getJobName()).withDescription(this.getJobDescription()).usingJobData(JOB_DATA_CONFIG_FILE, this.configFile).usingJobData(JOB_DATA_WEBAPP_FOLDER, this.webappFolder).build();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.interrupted) {
            return;
        }
        LOGGER.info("Start prerendering task");
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        JobDetail details = context.getJobDetail();
        JobDataMap jobDataMap = details.getJobDataMap();
        this.taskConfigPrerendering = this.readJobConfig(jobDataMap.getString(JOB_DATA_CONFIG_FILE));
        this.webappFolder = jobDataMap.getString(JOB_DATA_WEBAPP_FOLDER);
        List<PrerenderingJobConfig.RenderingConfig> phenomenonStyles = this.taskConfigPrerendering.getPhenomenonStyles();
        List<PrerenderingJobConfig.RenderingConfig> timeseriesStyles = this.taskConfigPrerendering.getTimeseriesStyles();
        for (PrerenderingJobConfig.RenderingConfig config : phenomenonStyles) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("phenomenon", config.getId());
            IoParameters query = QueryParameters.createFromQuery(parameters);
            OutputCollection metadatas = this.timeseriesMetadataService.getCondensedParameters(query);
            for (TimeseriesMetadataOutput metadata : metadatas) {
                String timeseriesId = metadata.getId();
                this.renderConfiguredIntervals(timeseriesId, config);
                if (!this.interrupted) continue;
                return;
            }
        }
        for (PrerenderingJobConfig.RenderingConfig config : timeseriesStyles) {
            this.renderConfiguredIntervals(config.getId(), config);
            if (!this.interrupted) continue;
            return;
        }
        LOGGER.debug("prerendering took '{}'", (Object)stopwatch.stopInSeconds());
    }

    private void renderConfiguredIntervals(String timeseriesId, PrerenderingJobConfig.RenderingConfig style) {
        try {
            for (String interval : style.getInterval()) {
                this.renderWithStyle(timeseriesId, style, interval);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error occured while prerendering timeseries {}.", (Object)timeseriesId, (Object)e);
        }
    }

    private void renderWithStyle(String timeseriesId, PrerenderingJobConfig.RenderingConfig renderingConfig, String interval) throws IOException, DatasetFactoryException, URISyntaxException {
        IntervalWithTimeZone timespan = this.createTimespanFromInterval(timeseriesId, interval);
        IoParameters config = this.createConfig(timespan.toString(), renderingConfig);
        TimeseriesMetadataOutput metadata = (TimeseriesMetadataOutput)this.timeseriesMetadataService.getParameter(timeseriesId, config);
        IoStyleContext context = IoStyleContext.createContextForSingleSeries((DatasetOutput)metadata, (IoParameters)config);
        int width = context.getChartStyleDefinitions().getWidth();
        int height = context.getChartStyleDefinitions().getHeight();
        context.setDimensions(new ChartDimension(width, height));
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)timeseriesId, (IoParameters)config);
        String chartQualifier = renderingConfig.getChartQualifier();
        FileOutputStream fos = this.createFile(timeseriesId, interval, chartQualifier);
        try (FileOutputStream out = fos;){
            this.createIoFactory(parameters).createHandler(IMAGE_EXTENSION).writeBinary((OutputStream)out);
            fos.flush();
        }
        catch (IOException | IoHandlerException e) {
            LOGGER.error("Image creation occures error.", e);
        }
    }

    private IoFactory<MeasurementData, TimeseriesMetadataOutput, MeasurementValue> createIoFactory(RequestSimpleParameterSet parameters) throws DatasetFactoryException, URISyntaxException, MalformedURLException {
        return ((IoFactory)new DefaultIoFactory().create("measurement")).withSimpleRequest(parameters).withDataService(this.timeseriesDataService).withDatasetService(this.timeseriesMetadataService);
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.interrupted = true;
        LOGGER.info("Marked job to interrupt.");
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.webappFolder = servletConfig.getServletContext().getRealPath("/");
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public ParameterService<TimeseriesMetadataOutput> getTimeseriesMetadataService() {
        return this.timeseriesMetadataService;
    }

    public void setTimeseriesMetadataService(ParameterService<TimeseriesMetadataOutput> timeseriesMetadataService) {
        this.timeseriesMetadataService = timeseriesMetadataService;
    }

    public DataService<MeasurementData> getTimeseriesDataService() {
        return this.timeseriesDataService;
    }

    public void setTimeseriesDataService(DataService<MeasurementData> timeseriesDataService) {
        this.timeseriesDataService = timeseriesDataService;
    }

    public boolean hasPrerenderedImage(String timeseriesId, String chartQualifier) {
        this.taskConfigPrerendering = this.readJobConfig(this.configFile);
        File fileName = this.createFileName(timeseriesId, chartQualifier);
        return fileName.exists();
    }

    public void writePrerenderedGraphToOutputStream(String timeseriesId, String chartQualifier, OutputStream outputStream) {
        try {
            BufferedImage image = this.loadImage(timeseriesId, chartQualifier);
            if (image == null) {
                ResourceNotFoundException ex = new ResourceNotFoundException("Could not find image on server.");
                ex.addHint("Perhaps the image is being rendered at the moment. Try again later.");
                throw ex;
            }
            ImageIO.write((RenderedImage)image, IMAGE_EXTENSION, outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error while loading pre rendered image", (Throwable)e);
        }
    }

    private BufferedImage loadImage(String timeseriesId, String chartQualifier) throws IOException {
        return ImageIO.read(new FileInputStream(this.createFileName(timeseriesId, chartQualifier)));
    }

    public IntervalWithTimeZone createTimespanFromInterval(String timeseriesId, String period) {
        DateTime now = new DateTime();
        if (period.equals("lastDay")) {
            Interval interval = new Interval((ReadableInstant)now.minusDays(1), (ReadableInstant)now);
            return new IntervalWithTimeZone(interval.toString());
        }
        if (period.equals("lastWeek")) {
            Interval interval = new Interval((ReadableInstant)now.minusWeeks(1), (ReadableInstant)now);
            return new IntervalWithTimeZone(interval.toString());
        }
        if (period.equals("lastMonth")) {
            Interval interval = new Interval((ReadableInstant)now.minusMonths(1), (ReadableInstant)now);
            return new IntervalWithTimeZone(interval.toString());
        }
        throw new ResourceNotFoundException("Unknown interval definition '" + period + "' for timeseriesId " + timeseriesId);
    }

    private FileOutputStream createFile(String timeseriesId, String interval, String postfix) throws IOException {
        String chartQualifier = postfix != null ? interval + "_" + postfix : interval;
        File file = this.createFileName(timeseriesId, chartQualifier);
        if (file.exists() && !file.setLastModified(new Date().getTime())) {
            LOGGER.debug("Can't set last modified date at '{}'", (Object)file.getAbsolutePath());
        } else if (!file.createNewFile()) {
            LOGGER.warn("Can't create file '{}'", (Object)file.getAbsolutePath());
        }
        return new FileOutputStream(file);
    }

    private File createFileName(String timeseriesId, String chartQualifier) {
        String outputDirectory = this.getOutputFolder();
        String filename = timeseriesId + "_" + chartQualifier + ".png";
        return new File(outputDirectory + filename);
    }

    private String getOutputFolder() {
        Map<String, String> generalConfig = this.taskConfigPrerendering.getGeneralConfig();
        String outputPath = generalConfig.get("outputPath");
        String outputDirectory = this.webappFolder + File.separator + outputPath + File.separator;
        File dir = new File(outputDirectory);
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.warn("Unable to create output folder '{}'.", (Object)outputDirectory);
        }
        return outputDirectory;
    }

    private IoParameters createConfig(String interval, PrerenderingJobConfig.RenderingConfig renderingConfig) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("width", Integer.toString(800));
        configuration.put("height", Integer.toString(500));
        configuration.put("grid", Boolean.toString(true));
        configuration.put("legend", Boolean.toString(false));
        configuration.put("generalize", Boolean.toString(false));
        configuration.put("locale", LANGUAGE_DEFAULT);
        configuration.put("timespan", interval);
        configuration.putAll(this.taskConfigPrerendering.getGeneralConfig());
        if (renderingConfig.getConfig() != null) {
            configuration.putAll(renderingConfig.getConfig());
        }
        configuration.put("rendering_trigger", "prerendering");
        try {
            ObjectMapper om = new ObjectMapper();
            configuration.put("style", om.writeValueAsString((Object)renderingConfig.getStyle()));
            configuration.put("title", renderingConfig.getTitle());
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Invalid rendering style.", (Throwable)e);
        }
        return QueryParameters.createFromQuery(configuration);
    }
}

